/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.script;

import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.cycle.script.ScriptEnvironment;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.cycle.script.LiteralScript;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;

public class ScriptUtil {
    private ScriptUtil() {
    }

    public static CompiledScript compile(String text, Class expectedClass) {
        CompiledScript compiled;
        if (expectedClass == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.hasValue(text)) {
            ScriptEnvironment environment = ProviderUtil.getScriptEnvironment();
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            NodeTreeWalker node = cycle.getInjectedNode();
            compiled = environment.compile(text, node);
        } else {
            compiled = new LiteralScript("");
        }
        compiled.setExpectedClass(expectedClass);
        return compiled;
    }

    public static String getBlockSignedText(String text) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        String blockSign = ProviderUtil.getScriptEnvironment().getBlockSign();
        text = String.valueOf(blockSign) + "{" + text.trim() + "}";
        return text;
    }
}

