/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.scope;

import java.util.Iterator;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.AttributeScope;
import org.seasar.maya.engine.processor.ProcessorProperty;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.cycle.scope.AbstractReadOnlyAttributeScope;
import org.seasar.maya.impl.engine.processor.DoRenderProcessor;
import org.seasar.maya.impl.engine.processor.InsertProcessor;

public class BindingScope
extends AbstractReadOnlyAttributeScope {
    protected InsertProcessor getInsertProcessor() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        ProcessorTreeWalker current = cycle.getProcessor();
        while (current != null) {
            if (current instanceof DoRenderProcessor) {
                DoRenderProcessor doRender = (DoRenderProcessor)current;
                return doRender.peekInsertProcessor();
            }
            current = current.getParentProcessor();
        }
        return null;
    }

    public String getScopeName() {
        return "binding";
    }

    public Iterator iterateAttributeNames() {
        InsertProcessor processor = this.getInsertProcessor();
        if (processor != null) {
            return new BindingIterator(processor.getInformalProperties().iterator());
        }
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope param = cycle.getAttributeScope("param");
        return param.iterateAttributeNames();
    }

    public boolean hasAttribute(String name) {
        InsertProcessor processor = this.getInsertProcessor();
        if (processor != null) {
            Iterator it = processor.getInformalProperties().iterator();
            while (it.hasNext()) {
                ProcessorProperty prop = (ProcessorProperty)it.next();
                if (!prop.getName().getQName().getLocalName().equals(name)) continue;
                return true;
            }
            return false;
        }
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope param = cycle.getAttributeScope("param");
        return param.hasAttribute(name);
    }

    public Object getAttribute(String name) {
        InsertProcessor processor = this.getInsertProcessor();
        if (processor != null) {
            Iterator it = processor.getInformalProperties().iterator();
            while (it.hasNext()) {
                ProcessorProperty prop = (ProcessorProperty)it.next();
                if (!prop.getName().getQName().getLocalName().equals(name)) continue;
                return prop.getValue().execute(null);
            }
            return null;
        }
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope param = cycle.getAttributeScope("param");
        return param.getAttribute(name);
    }

    private class BindingIterator
    implements Iterator {
        private Iterator _it;

        BindingIterator(Iterator it) {
            if (it == null) {
                throw new IllegalArgumentException();
            }
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            ProcessorProperty prop = (ProcessorProperty)this._it.next();
            return prop.getName().getQName().getLocalName();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

