/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library.scanner;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.seasar.maya.builder.library.scanner.SourceScanner;
import org.seasar.maya.cycle.scope.ApplicationScope;
import org.seasar.maya.impl.IllegalParameterValueException;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.source.ApplicationSourceDescriptor;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.NullIterator;

public class FolderSourceScanner
extends ParameterAwareImpl
implements SourceScanner {
    private ApplicationSourceDescriptor _source;
    private String _folder;
    private boolean _recursive = false;
    private Set _extensions = new HashSet();

    public String getFolder() {
        if (StringUtil.isEmpty(this._folder)) {
            throw new IllegalStateException();
        }
        return this._folder;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public Set getExtensions() {
        return Collections.unmodifiableSet(this._extensions);
    }

    protected String[] getExtensionArray() {
        return this._extensions.toArray(new String[this._extensions.size()]);
    }

    public Iterator scan() {
        if (this._source == null) {
            this._source = new ApplicationSourceDescriptor();
            this._source.setDenyWebInf(false);
            this._source.setRoot(this.getFolder());
        }
        if (this._source.exists() && this._source.getFile().isDirectory()) {
            return new FileToSourceIterator(this._source.getApplicationScope(), this._source.getRoot(), this.iterateFiles(this._source.getFile()));
        }
        return NullIterator.getInstance();
    }

    protected Iterator iterateFiles(File dir) {
        if (dir.exists()) {
            File[] files = dir.isDirectory() ? this.listFiles(dir) : new File[]{dir};
            return new FileArrayIterator(files);
        }
        return NullIterator.getInstance();
    }

    protected FileFilter createExtensionFilter() {
        return new FileFilter(){
            String[] extensions;
            {
                this.extensions = FolderSourceScanner.this.getExtensionArray();
            }

            public boolean accept(File pathName) {
                if (pathName.isDirectory()) {
                    return true;
                }
                int i = 0;
                while (i < this.extensions.length) {
                    if (pathName.getName().endsWith(this.extensions[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
    }

    protected File[] listFiles(File dir) {
        ArrayList sources = new ArrayList();
        FileFilter filter = this.createExtensionFilter();
        if (this._recursive) {
            this.listFilesRecursive(sources, dir, filter);
        } else {
            this.listFilesNonRecursive(sources, dir, filter);
        }
        return sources.toArray(new File[sources.size()]);
    }

    protected void listFilesNonRecursive(List list, File dir, FileFilter filter) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(filter);
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    list.add(files[i]);
                }
                ++i;
            }
        }
    }

    protected void listFilesRecursive(List list, File dir, FileFilter filter) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(filter);
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.listFilesRecursive(list, files[i], filter);
                } else {
                    list.add(files[i]);
                }
                ++i;
            }
        }
    }

    public void setParameter(String name, String value) {
        if ("folder".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this._folder = value;
        } else if ("recursive".equals(name)) {
            this._recursive = Boolean.valueOf(value);
        } else if ("extension".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            if (value.charAt(0) != '.') {
                this._extensions.add(String.valueOf('.') + value);
            } else {
                this._extensions.add(value);
            }
        }
        super.setParameter(name, value);
    }

    protected static class FileArrayIterator
    implements Iterator {
        private File[] _files;
        private int _index;

        public FileArrayIterator(File[] files) {
            if (files == null) {
                throw new IllegalArgumentException();
            }
            this._files = files;
        }

        public boolean hasNext() {
            return this._index < this._files.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._files[this._index++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class FileToSourceIterator
    implements Iterator {
        private ApplicationScope _applicationScope;
        private String _root;
        private Iterator _iterator;

        public FileToSourceIterator(ApplicationScope applicationScope, String root, Iterator iterator) {
            if (applicationScope == null || iterator == null) {
                throw new IllegalArgumentException();
            }
            this._applicationScope = applicationScope;
            this._root = root;
            this._iterator = iterator;
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        private String getSystemID(File file) {
            String sourceRoot = this._root;
            if (StringUtil.isEmpty(sourceRoot)) {
                sourceRoot = "/";
            }
            String root = this._applicationScope.getRealPath(sourceRoot);
            String absolutePath = file.getAbsolutePath();
            String path = absolutePath.substring(root.length());
            return StringUtil.preparePath(path);
        }

        public Object next() {
            Object ret = this._iterator.next();
            if (ret instanceof File) {
                File file = (File)ret;
                String systemID = this.getSystemID(file);
                ApplicationSourceDescriptor source = new ApplicationSourceDescriptor();
                source.setDenyWebInf(false);
                source.setRoot(this._root);
                source.setSystemID(systemID);
                source.setFile(file);
                return source;
            }
            throw new IllegalStateException();
        }

        public void remove() {
            this._iterator.remove();
        }
    }
}

