/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.builder.library.LibraryDefinition;
import org.seasar.maya.builder.library.PropertyDefinition;
import org.seasar.maya.builder.library.PropertySet;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.NullIterator;

public class PropertySetImpl
extends ParameterAwareImpl
implements PropertySet {
    private static final Log LOG;
    private LibraryDefinition _library;
    private String _name;
    private List _properties;
    private Set _propertyNames;
    private int _lineNumber;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.PropertySetImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void setLineNumber(int lineNumber) {
        if (lineNumber < 0) {
            throw new IllegalArgumentException();
        }
        this._lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setLibraryDefinition(LibraryDefinition library) {
        if (library == null) {
            throw new IllegalArgumentException();
        }
        this._library = library;
    }

    public LibraryDefinition getLibraryDefinition() {
        if (this._library == null) {
            throw new IllegalStateException();
        }
        return this._library;
    }

    public void setName(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    public String getName() {
        if (StringUtil.isEmpty(this._name)) {
            throw new IllegalStateException();
        }
        return this._name;
    }

    public void addPropertyDefinitiion(PropertyDefinition property) {
        String propName;
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (this._properties == null) {
            this._propertyNames = new HashSet();
            this._properties = new ArrayList();
        }
        if (this._propertyNames.add(propName = property.getName())) {
            this._properties.add(property);
        } else if (LOG.isWarnEnabled()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.PropertySetImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String msg = StringUtil.getMessage(clazz, 0, this.getName(), propName);
            LOG.warn((Object)msg);
        }
    }

    protected boolean contain(String namespaceURI, NodeAttribute attr) {
        if (StringUtil.isEmpty(namespaceURI) || attr == null) {
            throw new IllegalArgumentException();
        }
        if (this._propertyNames == null) {
            return false;
        }
        String attrNS = attr.getQName().getNamespaceURI();
        String attrName = attr.getQName().getLocalName();
        return this._propertyNames.contains(attrName) && namespaceURI.equals(attrNS);
    }

    public Iterator iteratePropertyDefinition() {
        if (this._properties == null) {
            return NullIterator.getInstance();
        }
        return this._properties.iterator();
    }
}

