/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.builder.library.LibraryDefinition;
import org.seasar.maya.builder.library.ProcessorDefinition;
import org.seasar.maya.builder.library.PropertyDefinition;
import org.seasar.maya.builder.library.PropertySet;
import org.seasar.maya.builder.library.converter.PropertyConverter;
import org.seasar.maya.engine.processor.InformalPropertyAcceptable;
import org.seasar.maya.engine.processor.TemplateProcessor;
import org.seasar.maya.engine.processor.VirtualPropertyAcceptable;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.builder.library.ConverterNotFoundException;
import org.seasar.maya.impl.builder.library.ConverterOperationException;
import org.seasar.maya.impl.builder.library.PropertySetImpl;
import org.seasar.maya.impl.builder.library.PropertySetNotFoundException;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.NullIterator;

public class ProcessorDefinitionImpl
extends PropertySetImpl
implements ProcessorDefinition {
    private static final Log LOG;
    private Class _processorClass;
    private List _propertySetRefs;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.ProcessorDefinitionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void setProcessorClass(Class processorClass) {
        block8: {
            block7: {
                if (processorClass == null) break block7;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.seasar.maya.engine.processor.TemplateProcessor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(processorClass)) break block8;
            }
            throw new IllegalArgumentException();
        }
        this._processorClass = processorClass;
    }

    public Class getProcessorClass() {
        return this._processorClass;
    }

    public void addPropertySetRef(String name, String systemID, int lineNumber) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._propertySetRefs == null) {
            this._propertySetRefs = new ArrayList();
        }
        if (this._propertySetRefs.contains(name)) {
            if (LOG.isWarnEnabled()) {
                String line = Integer.toString(lineNumber);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.ProcessorDefinitionImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                LOG.warn((Object)StringUtil.getMessage(clazz, 1, name, systemID, line));
            }
        } else {
            this._propertySetRefs.add(new PropertySetRef(name, systemID, lineNumber));
        }
    }

    public Iterator iteratePropertySets() {
        if (this._propertySetRefs == null) {
            return NullIterator.getInstance();
        }
        Iterator it = this._propertySetRefs.iterator();
        return new PropertySetIterator(it, this.getLibraryDefinition());
    }

    protected TemplateProcessor newInstance() {
        return (TemplateProcessor)ObjectUtil.newInstance(this._processorClass);
    }

    protected PrefixAwareName getPrefixAwareName(SpecificationNode injected, String propertyName) {
        QName qName = SpecificationUtil.createQName(injected.getQName().getNamespaceURI(), propertyName);
        return injected.getAttribute(qName);
    }

    protected void settingProperty(SpecificationNode injected, TemplateProcessor processor, PropertyDefinition property) {
        Object value = property.createProcessorProperty(this, injected);
        if (value != null) {
            String propertyName = property.getName();
            Class processorClass = this.getProcessorClass();
            if (ObjectUtil.hasProperty(processorClass, propertyName)) {
                ObjectUtil.setProperty(processor, propertyName, value);
            } else if (processor instanceof VirtualPropertyAcceptable) {
                VirtualPropertyAcceptable acceptable = (VirtualPropertyAcceptable)((Object)processor);
                PrefixAwareName name = this.getPrefixAwareName(injected, propertyName);
                acceptable.addVirtualProperty(name, value);
            } else if (LOG.isWarnEnabled()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.ProcessorDefinitionImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                LOG.warn((Object)StringUtil.getMessage(clazz, 2, processorClass.getName(), propertyName));
            }
        }
    }

    protected void settingPropertySet(SpecificationNode injected, TemplateProcessor processor, PropertySet propertySet) {
        Iterator it = propertySet.iteratePropertyDefinition();
        while (it.hasNext()) {
            PropertyDefinition property = (PropertyDefinition)it.next();
            this.settingProperty(injected, processor, property);
        }
    }

    protected void settingInformalProperties(SpecificationNode injected, InformalPropertyAcceptable acceptable) {
        String injectedNS = injected.getQName().getNamespaceURI();
        Iterator it = injected.iterateAttribute();
        while (it.hasNext()) {
            Class propertyClass;
            NodeAttribute attr = (NodeAttribute)it.next();
            if (this.contain(injectedNS, attr)) continue;
            LibraryDefinition library = this.getLibraryDefinition();
            PropertyConverter converter = library.getPropertyConverter(propertyClass = acceptable.getPropertyClass());
            if (converter == null) {
                throw new ConverterNotFoundException(propertyClass.getName(), this.getSystemID(), this.getLineNumber());
            }
            Class expectedClass = acceptable.getExpectedClass();
            String value = attr.getValue();
            Object property = converter.convert(attr, value, expectedClass);
            if (property == null) {
                throw new ConverterOperationException(converter, value);
            }
            acceptable.addInformalProperty(attr, property);
        }
    }

    public TemplateProcessor createTemplateProcessor(SpecificationNode injected) {
        if (injected == null) {
            throw new IllegalArgumentException();
        }
        TemplateProcessor processor = this.newInstance();
        processor.setProcessorDefinition(this);
        this.settingPropertySet(injected, processor, this);
        Iterator it = this.iteratePropertySets();
        while (it.hasNext()) {
            PropertySet propertySet = (PropertySet)it.next();
            this.settingPropertySet(injected, processor, propertySet);
        }
        if (processor instanceof InformalPropertyAcceptable) {
            this.settingInformalProperties(injected, (InformalPropertyAcceptable)((Object)processor));
        }
        return processor;
    }

    protected class PropertySetRef {
        private String _name;
        private String _systemID;
        private int _lineNumber;

        public PropertySetRef(String name, String systemID, int lineNumber) {
            if (StringUtil.isEmpty(name) || StringUtil.isEmpty(systemID) || lineNumber < 0) {
                throw new IllegalArgumentException();
            }
            this._name = name;
            this._systemID = systemID;
            this._lineNumber = lineNumber;
        }

        public String getName() {
            return this._name;
        }

        public String getSystemID() {
            return this._systemID;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }
    }

    protected class PropertySetIterator
    implements Iterator {
        private Iterator _it;
        private LibraryDefinition _library;

        public PropertySetIterator(Iterator it, LibraryDefinition library) {
            if (it == null || library == null) {
                throw new IllegalArgumentException();
            }
            this._it = it;
            this._library = library;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            PropertySetRef ref = (PropertySetRef)this._it.next();
            PropertySet propertySet = this._library.getPropertySet(ref.getName());
            if (propertySet == null) {
                throw new PropertySetNotFoundException(ref.getName(), ref.getSystemID(), ref.getLineNumber());
            }
            return propertySet;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

