/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.injection;

import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.builder.injection.InjectionResolver;
import org.seasar.maya.builder.library.LibraryManager;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.BuilderUtil;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;

public class InsertSetter
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    protected static final QName QM_INSERT = SpecificationUtil.createQName("insert");
    protected static final QName QM_PATH = SpecificationUtil.createQName("path");

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        LibraryManager libraryManager;
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        SpecificationNode injected = chain.getNode(original);
        QName qName = injected.getQName();
        String uri = qName.getNamespaceURI();
        if (uri.startsWith("/") && (libraryManager = ProviderUtil.getLibraryManager()).getProcessorDefinition(qName) == null) {
            String name = qName.getLocalName();
            String path = String.valueOf(StringUtil.preparePath(uri)) + StringUtil.preparePath(name);
            SpecificationNode node = BuilderUtil.createInjectedNode(QM_INSERT, uri, injected, false);
            node.addAttribute(QM_PATH, path);
            String compName = SpecificationUtil.getAttributeValue(injected, QM_NAME);
            if (StringUtil.hasValue(compName)) {
                node.addAttribute(QM_NAME, compName);
            }
            return node;
        }
        return injected;
    }
}

