/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.injection;

import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.builder.injection.InjectionResolver;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.BuilderUtil;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.StringUtil;

public class InjectAttributeInjectionResolver
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    protected static final QName QM_INJECT = SpecificationUtil.createQName("inject");

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        PrefixAwareName prefixAwareName;
        QName qName;
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        String injectName = SpecificationUtil.getAttributeValue(original, QM_INJECT);
        if (StringUtil.hasValue(injectName) && !QM_IGNORE.equals(qName = (prefixAwareName = BuilderUtil.parseName(original, injectName)).getQName())) {
            String uri = qName.getNamespaceURI();
            return BuilderUtil.createInjectedNode(qName, uri, original, true);
        }
        return chain.getNode(original);
    }
}

