/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder;

import java.io.InputStream;
import org.seasar.maya.builder.SpecificationBuilder;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.SpecificationNodeHandler;
import org.seasar.maya.impl.util.IOUtil;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.xml.XMLReaderPool;
import org.seasar.maya.source.SourceDescriptor;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SpecificationBuilderImpl
extends ParameterAwareImpl
implements SpecificationBuilder,
CONST_IMPL {
    private static final long serialVersionUID = 7852577574830768959L;
    private boolean _outputWhitespace = true;

    protected XMLReaderPool getXMLReaderPool(String systemID) {
        return XMLReaderPool.getPool();
    }

    protected ContentHandler createContentHandler(Specification specification) {
        SpecificationNodeHandler handler = new SpecificationNodeHandler(specification);
        handler.setOutputWhitespace(this._outputWhitespace);
        return handler;
    }

    protected String getPublicID() {
        return "http://maya.seasar.org/specification";
    }

    protected void afterBuild(Specification specification) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(Specification specification) {
        if (specification == null) {
            throw new IllegalArgumentException();
        }
        SourceDescriptor source = specification.getSource();
        if (!source.exists()) return;
        ContentHandler handler = this.createContentHandler(specification);
        XMLReaderPool pool = this.getXMLReaderPool(source.getSystemID());
        XMLReader xmlReader = pool.borrowXMLReader(handler, true, false, false);
        InputStream stream = source.getInputStream();
        InputSource input = new InputSource(stream);
        input.setPublicId(this.getPublicID());
        input.setSystemId(source.getSystemID());
        try {
            try {
                xmlReader.parse(input);
                this.afterBuild(specification);
            }
            catch (Throwable t) {
                specification.kill();
                if (!(t instanceof RuntimeException)) throw new RuntimeException(t);
                throw (RuntimeException)t;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            pool.returnXMLReader(xmlReader);
            IOUtil.close(stream);
            throw throwable;
        }
        {
            Object var9_11 = null;
            pool.returnXMLReader(xmlReader);
        }
        IOUtil.close(stream);
    }

    public void setParameter(String name, String value) {
        if ("outputWhitespace".equals(name)) {
            this._outputWhitespace = ObjectUtil.booleanValue(value, true);
        }
        super.setParameter(name, value);
    }
}

