/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.Var;
import org.apache.commons.validator.util.ValidatorUtils;

public class Field
implements Cloneable,
Serializable {
    private static final String DEFAULT_ARG = "org.apache.commons.validator.Field.DEFAULT";
    public static final String ARG_DEFAULT = "org.apache.commons.validator.Field.DEFAULT";
    public static final String TOKEN_INDEXED = "[]";
    protected static final String TOKEN_START = "${";
    protected static final String TOKEN_END = "}";
    protected static final String TOKEN_VAR = "var:";
    protected String property = null;
    protected String indexedProperty = null;
    protected String indexedListProperty = null;
    protected String key = null;
    protected String depends = null;
    protected int page = 0;
    protected int fieldOrder = 0;
    protected FastHashMap hDependencies = new FastHashMap();
    private List dependencyList = Collections.synchronizedList(new ArrayList());
    protected FastHashMap hVars = new FastHashMap();
    protected FastHashMap hMsgs = new FastHashMap();
    protected Map[] args = new Map[0];
    protected FastHashMap hArg0 = new FastHashMap();
    protected FastHashMap hArg1 = new FastHashMap();
    protected FastHashMap hArg2 = new FastHashMap();
    protected FastHashMap hArg3 = new FastHashMap();

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(int fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getIndexedProperty() {
        return this.indexedProperty;
    }

    public void setIndexedProperty(String indexedProperty) {
        this.indexedProperty = indexedProperty;
    }

    public String getIndexedListProperty() {
        return this.indexedListProperty;
    }

    public void setIndexedListProperty(String indexedListProperty) {
        this.indexedListProperty = indexedListProperty;
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String depends) {
        this.depends = depends;
        this.dependencyList.clear();
        StringTokenizer st = new StringTokenizer(depends, ",");
        while (st.hasMoreTokens()) {
            String depend = st.nextToken().trim();
            if (depend == null || depend.length() <= 0) continue;
            this.dependencyList.add(depend);
        }
    }

    public void addMsg(Msg msg) {
        this.hMsgs.put((Object)msg.getName(), (Object)msg);
    }

    public String getMsg(String key) {
        Msg msg = this.getMessage(key);
        return msg == null ? null : msg.getKey();
    }

    public Msg getMessage(String key) {
        return (Msg)this.hMsgs.get((Object)key);
    }

    public Map getMessages() {
        return Collections.unmodifiableMap(this.hMsgs);
    }

    public void addArg(Arg arg) {
        if (arg == null || arg.getKey() == null || arg.getKey().length() == 0) {
            return;
        }
        this.ensureArgsCapacity(arg);
        HashMap<String, Arg> argMap = this.args[arg.getPosition()];
        if (argMap == null) {
            this.args[arg.getPosition()] = argMap = new HashMap<String, Arg>();
        }
        if (arg.getName() == null) {
            argMap.put("org.apache.commons.validator.Field.DEFAULT", arg);
        } else {
            argMap.put(arg.getName(), arg);
        }
    }

    private void ensureArgsCapacity(Arg arg) {
        if (arg.getPosition() >= this.args.length) {
            Map[] newArgs = new Map[arg.getPosition() + 1];
            System.arraycopy(this.args, 0, newArgs, 0, this.args.length);
            this.args = newArgs;
        }
    }

    public Arg getArg(int position) {
        return this.getArg("org.apache.commons.validator.Field.DEFAULT", position);
    }

    public Arg getArg(String key, int position) {
        if (position >= this.args.length || this.args[position] == null) {
            return null;
        }
        Arg arg = (Arg)this.args[position].get(key);
        if (arg == null && key.equals("org.apache.commons.validator.Field.DEFAULT")) {
            return null;
        }
        return arg == null ? this.getArg(position) : arg;
    }

    public Arg[] getArgs(String key) {
        Arg[] args = new Arg[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            args[i] = this.getArg(key, i);
        }
        return args;
    }

    public void addArg0(Arg arg) {
        arg.setPosition(0);
        this.addArg(arg);
    }

    public Arg getArg0() {
        return this.getArg(0);
    }

    public Arg getArg0(String key) {
        return this.getArg(key, 0);
    }

    public void addArg1(Arg arg) {
        arg.setPosition(1);
        this.addArg(arg);
    }

    public Arg getArg1() {
        return this.getArg(1);
    }

    public Arg getArg1(String key) {
        return this.getArg(key, 1);
    }

    public void addArg2(Arg arg) {
        arg.setPosition(2);
        this.addArg(arg);
    }

    public Arg getArg2() {
        return this.getArg(2);
    }

    public Arg getArg2(String key) {
        return this.getArg(key, 2);
    }

    public void addArg3(Arg arg) {
        arg.setPosition(3);
        this.addArg(arg);
    }

    public Arg getArg3() {
        return this.getArg(3);
    }

    public Arg getArg3(String key) {
        return this.getArg(key, 3);
    }

    public void addVar(Var v) {
        this.hVars.put((Object)v.getName(), (Object)v);
    }

    public void addVarParam(String name, String value, String jsType) {
        this.addVar(new Var(name, value, jsType));
    }

    public void addVar(String name, String value, String jsType) {
        this.addVar(new Var(name, value, jsType));
    }

    public Var getVar(String mainKey) {
        return (Var)this.hVars.get((Object)mainKey);
    }

    public String getVarValue(String mainKey) {
        String value = null;
        Object o = this.hVars.get((Object)mainKey);
        if (o != null && o instanceof Var) {
            Var v = (Var)o;
            value = v.getValue();
        }
        return value;
    }

    public Map getVars() {
        return Collections.unmodifiableMap(this.hVars);
    }

    public String getKey() {
        if (this.key == null) {
            this.generateKey();
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isIndexed() {
        return this.indexedListProperty != null && this.indexedListProperty.length() > 0;
    }

    public void generateKey() {
        this.key = this.isIndexed() ? this.indexedListProperty + TOKEN_INDEXED + "." + this.property : this.property;
    }

    public void process(Map globalConstants, Map constants) {
        String replaceValue;
        String key2;
        String key;
        this.hMsgs.setFast(false);
        this.hVars.setFast(true);
        this.generateKey();
        Iterator<Object> i = constants.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            key2 = TOKEN_START + key + TOKEN_END;
            replaceValue = (String)constants.get(key);
            this.property = ValidatorUtils.replace(this.property, key2, replaceValue);
            this.processVars(key2, replaceValue);
            this.processMessageComponents(key2, replaceValue);
        }
        i = globalConstants.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            key2 = TOKEN_START + key + TOKEN_END;
            replaceValue = (String)globalConstants.get(key);
            this.property = ValidatorUtils.replace(this.property, key2, replaceValue);
            this.processVars(key2, replaceValue);
            this.processMessageComponents(key2, replaceValue);
        }
        i = this.hVars.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            key2 = "${var:" + key + TOKEN_END;
            Var var = this.getVar(key);
            String replaceValue2 = var.getValue();
            this.processMessageComponents(key2, replaceValue2);
        }
        this.hMsgs.setFast(true);
    }

    private void processVars(String key, String replaceValue) {
        Iterator i = this.hVars.keySet().iterator();
        while (i.hasNext()) {
            String varKey = (String)i.next();
            Var var = this.getVar(varKey);
            var.setValue(ValidatorUtils.replace(var.getValue(), key, replaceValue));
        }
    }

    public void processMessageComponents(String key, String replaceValue) {
        this.internalProcessMessageComponents(key, replaceValue);
    }

    private void internalProcessMessageComponents(String key, String replaceValue) {
        String varKey = "${var:";
        if (key != null && !key.startsWith(varKey)) {
            Iterator i = this.hMsgs.values().iterator();
            while (i.hasNext()) {
                Msg msg = (Msg)i.next();
                msg.setKey(ValidatorUtils.replace(msg.getKey(), key, replaceValue));
            }
        }
        this.processArg(key, replaceValue);
    }

    private void processArg(String key, String replaceValue) {
        for (int i = 0; i < this.args.length; ++i) {
            Map argMap = this.args[i];
            if (argMap == null) continue;
            Iterator iter = argMap.values().iterator();
            while (iter.hasNext()) {
                Arg arg = (Arg)iter.next();
                if (arg == null) continue;
                arg.setKey(ValidatorUtils.replace(arg.getKey(), key, replaceValue));
            }
        }
    }

    public boolean isDependency(String validatorName) {
        return this.dependencyList.contains(validatorName);
    }

    public Collection getDependencies() {
        return this.getDependencyList();
    }

    public List getDependencyList() {
        return Collections.unmodifiableList(this.dependencyList);
    }

    public Object clone() {
        Field field = null;
        try {
            field = (Field)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
        field.args = new Map[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            HashMap<String, Object> argMap = new HashMap<String, Object>(this.args[i]);
            Iterator iter = argMap.keySet().iterator();
            while (iter.hasNext()) {
                String validatorName = (String)iter.next();
                Arg arg = (Arg)argMap.get(validatorName);
                argMap.put(validatorName, arg.clone());
            }
            field.args[i] = argMap;
        }
        field.hVars = ValidatorUtils.copyFastHashMap(this.hVars);
        field.hMsgs = ValidatorUtils.copyFastHashMap(this.hMsgs);
        field.hArg0 = ValidatorUtils.copyFastHashMap(this.hArg0);
        field.hArg1 = ValidatorUtils.copyFastHashMap(this.hArg1);
        field.hArg2 = ValidatorUtils.copyFastHashMap(this.hArg2);
        field.hArg3 = ValidatorUtils.copyFastHashMap(this.hArg3);
        return field;
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        results.append("\t\tkey = " + this.key + "\n");
        results.append("\t\tproperty = " + this.property + "\n");
        results.append("\t\tindexedProperty = " + this.indexedProperty + "\n");
        results.append("\t\tindexedListProperty = " + this.indexedListProperty + "\n");
        results.append("\t\tdepends = " + this.depends + "\n");
        results.append("\t\tpage = " + this.page + "\n");
        results.append("\t\tfieldOrder = " + this.fieldOrder + "\n");
        if (this.hVars != null) {
            results.append("\t\tVars:\n");
            Iterator i = this.hVars.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                results.append("\t\t\t");
                results.append(key);
                results.append("=");
                results.append(this.hVars.get(key));
                results.append("\n");
            }
        }
        return results.toString();
    }

    Object[] getIndexedProperty(Object bean) throws ValidatorException {
        Object indexedProperty = null;
        try {
            indexedProperty = PropertyUtils.getProperty((Object)bean, (String)this.getIndexedListProperty());
        }
        catch (IllegalAccessException e) {
            throw new ValidatorException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ValidatorException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ValidatorException(e.getMessage());
        }
        if (indexedProperty instanceof Collection) {
            return ((Collection)indexedProperty).toArray();
        }
        if (indexedProperty.getClass().isArray()) {
            return (Object[])indexedProperty;
        }
        throw new ValidatorException(this.getKey() + " is not indexed");
    }

    private boolean validateForRule(ValidatorAction va, ValidatorResults results, Map actions, Map params, int pos) throws ValidatorException {
        ValidatorResult result = results.getValidatorResult(this.getKey());
        if (result != null && result.containsAction(va.getName())) {
            return result.isValid(va.getName());
        }
        if (!this.runDependentValidators(va, results, actions, params, pos)) {
            return false;
        }
        return va.executeValidationMethod(this, params, results, pos);
    }

    private boolean runDependentValidators(ValidatorAction va, ValidatorResults results, Map actions, Map params, int pos) throws ValidatorException {
        List dependentValidators = va.getDependencyList();
        if (dependentValidators.isEmpty()) {
            return true;
        }
        Iterator iter = dependentValidators.iterator();
        while (iter.hasNext()) {
            String depend = (String)iter.next();
            ValidatorAction action = (ValidatorAction)actions.get(depend);
            if (action == null) {
                this.handleMissingAction(depend);
            }
            if (this.validateForRule(action, results, actions, params, pos)) continue;
            return false;
        }
        return true;
    }

    ValidatorResults validate(Map params, Map actions) throws ValidatorException {
        if (this.getDepends() == null) {
            return new ValidatorResults();
        }
        ValidatorResults allResults = new ValidatorResults();
        Object bean = params.get("java.lang.Object");
        int numberOfFieldsToValidate = this.isIndexed() ? this.getIndexedProperty(bean).length : 1;
        for (int fieldNumber = 0; fieldNumber < numberOfFieldsToValidate; ++fieldNumber) {
            Iterator dependencies = this.dependencyList.iterator();
            while (dependencies.hasNext()) {
                String depend = (String)dependencies.next();
                ValidatorAction action = (ValidatorAction)actions.get(depend);
                if (action == null) {
                    this.handleMissingAction(depend);
                }
                ValidatorResults results = new ValidatorResults();
                boolean good = this.validateForRule(action, results, actions, params, fieldNumber);
                allResults.merge(results);
                if (good) continue;
                return allResults;
            }
        }
        return allResults;
    }

    private void handleMissingAction(String name) throws ValidatorException {
        throw new ValidatorException("No ValidatorAction named " + name + " found for field " + this.getProperty());
    }
}

