/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.util.xml;

import java.util.Stack;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.xml.TagHandler;
import org.xml.sax.Attributes;

public class TagHandlerStack {
    private String _rootName;
    private TagHandler _rootHandler;
    private Stack _stack;

    public TagHandlerStack(TagHandler rootHandler) {
        if (rootHandler == null) {
            throw new IllegalArgumentException();
        }
        this._stack = new Stack();
        this._rootName = rootHandler.getName();
        this._rootHandler = rootHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String name, Attributes attributes, String systemID, int lineNumber) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._stack.size() == 0) {
            if (!this._rootName.equalsIgnoreCase(name)) throw new IllegalStateException();
            this._rootHandler.start(attributes, systemID, lineNumber);
            this._stack.push(this._rootHandler);
            return;
        } else {
            TagHandler top = (TagHandler)this._stack.peek();
            TagHandler handler = top.startElement(name, attributes, systemID, lineNumber);
            this._stack.push(handler);
        }
    }

    public void endElement() {
        if (this._stack.size() > 0) {
            TagHandler top = (TagHandler)this._stack.pop();
            if (top.isValid()) {
                top.endElement();
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void characters(char[] buffer, int offset, int length) {
        TagHandler top = (TagHandler)this._stack.peek();
        top.characters(new String(buffer, offset, length).trim());
    }

    public TagHandler getRoot() {
        return this._rootHandler;
    }
}

