/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.source;

import java.util.Iterator;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.source.PageSourceFactory;
import org.seasar.maya.source.SourceDescriptor;

public class PageSourceFactoryImpl
extends ParameterAwareImpl
implements PageSourceFactory {
    private static final long serialVersionUID = 3334813227060846723L;
    private Object _context;
    private Class _serviceClass;

    public void setServiceClass(Class serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException();
        }
        this._serviceClass = serviceClass;
    }

    public Class getServiceClass() {
        if (this._serviceClass == null) {
            throw new IllegalArgumentException();
        }
        return this._serviceClass;
    }

    public SourceDescriptor getPageSource(String systemID) {
        if (StringUtil.isEmpty(systemID)) {
            throw new IllegalArgumentException();
        }
        Class sourceClass = this.getServiceClass();
        if (sourceClass == null) {
            throw new IllegalStateException();
        }
        SourceDescriptor source = (SourceDescriptor)ObjectUtil.newInstance(sourceClass);
        source.setSystemID(systemID);
        Iterator it = this.iterateParameterNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = this.getParameter(key);
            source.setParameter(key, value);
        }
        return source;
    }

    public void setUnderlyingContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this._context = context;
    }

    public Object getUnderlyingContext() {
        if (this._context == null) {
            throw new IllegalStateException();
        }
        return this._context;
    }
}

