/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.engine.processor.ProcessorProperty;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.impl.cycle.script.ScriptUtil;

public class ProcessorPropertyImpl
implements ProcessorProperty {
    private PrefixAwareName _name;
    private CompiledScript _compiled;

    public ProcessorPropertyImpl(PrefixAwareName name, String value, Class expectedClass) {
        if (name == null || expectedClass == null) {
            throw new IllegalArgumentException();
        }
        this._name = name;
        this._compiled = ScriptUtil.compile(value, expectedClass);
    }

    public PrefixAwareName getName() {
        return this._name;
    }

    public CompiledScript getValue() {
        return this._compiled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessorProperty) {
            PrefixAwareName otherName = ((ProcessorProperty)obj).getName();
            return this._name.getQName().equals(otherName.getQName());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this._name.toString()) + "=\"" + this._compiled.toString() + "\"";
    }
}

