/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.seasar.maya.cycle.CycleWriter;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.ChildEvaluationProcessor;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorProperty;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.processor.TryCatchFinallyProcessor;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.jsp.BodyContentImpl;
import org.seasar.maya.impl.cycle.jsp.PageContextImpl;
import org.seasar.maya.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.collection.AbstractSoftReferencePool;
import org.seasar.maya.impl.util.collection.NullIterator;

public class JspProcessor
extends TemplateProcessorSupport
implements ChildEvaluationProcessor,
TryCatchFinallyProcessor,
CONST_IMPL {
    private static final long serialVersionUID = -4416320364576454337L;
    private static PageContext _pageContext = new PageContextImpl();
    private static Map _tagPools = new HashMap();
    private Class _tagClass;
    private List _properties;
    private String _attributesKey;
    private ThreadLocal _loadedTag = new ThreadLocal();
    static /* synthetic */ Class class$0;

    public void setTagClass(Class tagClass) {
        block8: {
            block7: {
                if (tagClass == null) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.servlet.jsp.tagext.Tag");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(tagClass)) break block8;
            }
            throw new IllegalArgumentException();
        }
        this._tagClass = tagClass;
    }

    public void addProcessorProperty(ProcessorProperty property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (this._attributesKey != null) {
            throw new IllegalStateException();
        }
        if (this._properties == null) {
            this._properties = new ArrayList();
        }
        this._properties.add(property);
    }

    protected Iterator iterateProperties() {
        if (this._properties == null) {
            return NullIterator.getInstance();
        }
        return this._properties.iterator();
    }

    protected String getAttributesKey() {
        if (this._attributesKey == null) {
            StringBuffer buffer = new StringBuffer();
            Iterator it = this.iterateProperties();
            while (it.hasNext()) {
                ProcessorProperty property = (ProcessorProperty)it.next();
                String localName = property.getName().getQName().getLocalName();
                buffer.append("%").append(localName);
            }
            this._attributesKey = buffer.toString();
        }
        return this._attributesKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TagPool getTagPool() {
        Map map = _tagPools;
        synchronized (map) {
            String key = String.valueOf(this._tagClass.getName()) + this.getAttributesKey();
            TagPool pool = (TagPool)_tagPools.get(key);
            if (pool == null) {
                pool = new TagPool(this._tagClass);
                _tagPools.put(key, pool);
            }
            return pool;
        }
    }

    protected void clearLoadedTag() {
        this._loadedTag.set(null);
    }

    protected Tag getLoadedTag() {
        Tag tag = (Tag)this._loadedTag.get();
        if (tag == null) {
            tag = this.getTagPool().borrowTag();
            tag.setPageContext(_pageContext);
            this._loadedTag.set(tag);
        }
        return tag;
    }

    protected void releaseLoadedTag() {
        Tag tag = (Tag)this._loadedTag.get();
        this._loadedTag.set(null);
        tag.release();
        this.getTagPool().returnTag(tag);
    }

    protected ProcessStatus getProcessStatus(int status, boolean doStart) {
        if (status == 1) {
            return ProcessStatus.EVAL_BODY_INCLUDE;
        }
        if (status == 0) {
            return ProcessStatus.SKIP_BODY;
        }
        if (status == 6) {
            return ProcessStatus.EVAL_PAGE;
        }
        if (status == 5) {
            return ProcessStatus.SKIP_PAGE;
        }
        if (!doStart && status == 2) {
            return ProcessStatus.EVAL_BODY_AGAIN;
        }
        if (doStart && status == 2) {
            return ProcessStatus.EVAL_BODY_BUFFERED;
        }
        throw new IllegalArgumentException();
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._tagClass == null) {
            throw new IllegalStateException();
        }
        this.clearLoadedTag();
        Tag customTag = this.getLoadedTag();
        Iterator it = this.iterateProperties();
        while (it.hasNext()) {
            ProcessorProperty property = (ProcessorProperty)it.next();
            String propertyName = property.getName().getQName().getLocalName();
            Object value = property.getValue().execute(null);
            ObjectUtil.setProperty(customTag, propertyName, value);
        }
        ProcessorTreeWalker processor = this;
        while ((processor = processor.getParentProcessor()) != null) {
            if (!(processor instanceof JspProcessor)) continue;
            ProcessorTreeWalker jspProcessor = processor;
            Tag parentTag = ((JspProcessor)jspProcessor).getLoadedTag();
            if (parentTag == null) {
                throw new IllegalStateException("the parent processor has no custom tag.");
            }
            customTag.setParent(parentTag);
            break;
        }
        try {
            int result = customTag.doStartTag();
            return this.getProcessStatus(result, true);
        }
        catch (JspException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessStatus doEndProcess() {
        Tag customTag = this.getLoadedTag();
        try {
            try {
                int ret = customTag.doEndTag();
                ProcessStatus processStatus = this.getProcessStatus(ret, true);
                Object var3_5 = null;
                if (this.canCatch()) return processStatus;
                this.releaseLoadedTag();
                return processStatus;
            }
            catch (JspException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (this.canCatch()) throw throwable;
            this.releaseLoadedTag();
            throw throwable;
        }
    }

    public boolean isChildEvaluation() {
        return this.getLoadedTag() instanceof BodyTag;
    }

    public void setBodyContent(CycleWriter body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Tag tag = this.getLoadedTag();
        if (!(tag instanceof BodyTag)) {
            throw new IllegalStateException();
        }
        BodyTag bodyTag = (BodyTag)tag;
        bodyTag.setBodyContent((BodyContent)new BodyContentImpl(body));
    }

    public void doInitChildProcess() {
        Tag tag = this.getLoadedTag();
        if (tag instanceof BodyTag) {
            BodyTag bodyTag = (BodyTag)tag;
            try {
                bodyTag.doInitBody();
            }
            catch (JspException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public boolean isIteration() {
        return this.getLoadedTag() instanceof IterationTag;
    }

    public ProcessStatus doAfterChildProcess() {
        Tag tag = this.getLoadedTag();
        if (tag instanceof IterationTag) {
            IterationTag iterationTag = (IterationTag)tag;
            try {
                int ret = iterationTag.doAfterBody();
                return this.getProcessStatus(ret, false);
            }
            catch (JspException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException();
    }

    public boolean canCatch() {
        try {
            return this.getLoadedTag() instanceof TryCatchFinally;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void doCatchProcess(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        Tag tag = this.getLoadedTag();
        if (tag instanceof TryCatchFinally) {
            TryCatchFinally tryCatch = (TryCatchFinally)tag;
            try {
                tryCatch.doCatch(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFinallyProcess() {
        Tag tag = this.getLoadedTag();
        if (!(tag instanceof TryCatchFinally)) throw new IllegalStateException();
        TryCatchFinally tryCatch = (TryCatchFinally)tag;
        try {
            tryCatch.doFinally();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.releaseLoadedTag();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.releaseLoadedTag();
            return;
        }
    }

    protected class TagPool
    extends AbstractSoftReferencePool {
        private static final long serialVersionUID = -4519484537723904500L;
        private Class _clazz;
        static /* synthetic */ Class class$0;

        public TagPool(Class clazz) {
            block8: {
                block7: {
                    if (clazz == null) break block7;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("javax.servlet.jsp.tagext.Tag");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2.isAssignableFrom(clazz)) break block8;
                }
                throw new IllegalArgumentException();
            }
            this._clazz = clazz;
        }

        protected Object createObject() {
            return ObjectUtil.newInstance(this._clazz);
        }

        protected boolean validateObject(Object object) {
            return object instanceof Tag;
        }

        public Tag borrowTag() {
            return (Tag)this.borrowObject();
        }

        public void returnTag(Tag tag) {
            if (tag != null) {
                this.returnObject(tag);
            }
        }
    }
}

