/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.IterationProcessor;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorProperty;
import org.seasar.maya.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.maya.impl.engine.processor.TooManyLoopException;
import org.seasar.maya.impl.util.ObjectUtil;

public class ForProcessor
extends TemplateProcessorSupport
implements IterationProcessor {
    private static final long serialVersionUID = -1762792311844341560L;
    private ProcessorProperty _init;
    private ProcessorProperty _test;
    private ProcessorProperty _after;
    private int _max = 256;
    private ThreadLocal _counter = new ThreadLocal();

    public void setInit(ProcessorProperty init) {
        this._init = init;
    }

    public void setTest(ProcessorProperty test) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        this._test = test;
    }

    public void setAfter(ProcessorProperty after) {
        this._after = after;
    }

    public void setMax(int max) {
        this._max = max;
    }

    public boolean isIteration() {
        return true;
    }

    protected boolean execTest() {
        if (this._test == null) {
            throw new IllegalStateException();
        }
        int count = (Integer)this._counter.get();
        if (this._max >= 0 && this._max < count) {
            throw new TooManyLoopException(this._max);
        }
        this._counter.set(new Integer(++count));
        return ObjectUtil.booleanValue(this._test.getValue().execute(null), false);
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        this._counter.set(new Integer(0));
        if (this._init != null) {
            this._init.getValue().execute(null);
        }
        return this.execTest() ? ProcessStatus.EVAL_BODY_INCLUDE : ProcessStatus.SKIP_BODY;
    }

    public ProcessStatus doAfterChildProcess() {
        if (this._after != null) {
            this._after.getValue().execute(null);
        }
        return this.execTest() ? ProcessStatus.EVAL_BODY_AGAIN : ProcessStatus.SKIP_BODY;
    }
}

