/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.engine.Engine;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.Template;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.script.ScriptUtil;
import org.seasar.maya.impl.engine.EngineUtil;
import org.seasar.maya.impl.engine.PageNotFoundException;
import org.seasar.maya.impl.engine.RenderUtil;
import org.seasar.maya.impl.engine.TemplateImpl;
import org.seasar.maya.impl.engine.specification.SpecificationImpl;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.source.SourceUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.source.SourceDescriptor;

public class PageImpl
extends SpecificationImpl
implements Page,
Serializable,
CONST_IMPL {
    private static final long serialVersionUID = -5345416943673041700L;
    protected static final QName QM_EXTENDS = SpecificationUtil.createQName("extends");
    private Page _superPage;
    private String _superSuffix;
    private String _superExtension;
    private String _pageName;
    private List _templates;
    static /* synthetic */ Class class$0;

    public PageImpl(String pageName) {
        if (StringUtil.isEmpty(pageName)) {
            throw new IllegalArgumentException();
        }
        this._pageName = pageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        PageImpl pageImpl = this;
        synchronized (pageImpl) {
            this._superPage = null;
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareSuper() {
        PageImpl pageImpl = this;
        synchronized (pageImpl) {
            if (this._superPage != null) {
                return;
            }
            String extendsPath = SpecificationUtil.getMayaAttributeValue(this, QM_EXTENDS);
            if (StringUtil.isEmpty(extendsPath)) {
                return;
            }
            Engine engine = ProviderUtil.getEngine();
            String suffixSeparator = engine.getParameter("suffixSeparator");
            String[] pagePath = StringUtil.parsePath(extendsPath, suffixSeparator);
            this._superPage = engine.getPage(pagePath[0]);
            this._superSuffix = pagePath[1];
            this._superExtension = pagePath[2];
        }
    }

    public Page getSuperPage() {
        this.prepareSuper();
        return this._superPage;
    }

    public String getSuperSuffix() {
        this.prepareSuper();
        return this._superSuffix;
    }

    public String getSuperExtension() {
        this.prepareSuper();
        return this._superExtension;
    }

    public String getPageName() {
        return this._pageName;
    }

    public CompiledScript getSuffixScript() {
        Class<?> clazz;
        String value = SpecificationUtil.getMayaAttributeValue(this, QM_TEMPLATE_SUFFIX);
        if (StringUtil.isEmpty(value)) {
            value = SpecificationUtil.getMayaAttributeValue(ProviderUtil.getEngine(), QM_TEMPLATE_SUFFIX);
        }
        if (StringUtil.isEmpty(value)) {
            value = "";
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ScriptUtil.compile(value, clazz);
    }

    protected Template findTemplateFromCache(String suffix, String extension) {
        if (this._templates != null) {
            SpecificationImpl.ChildSpecificationsIterator it = new SpecificationImpl.ChildSpecificationsIterator(this, this._templates);
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof Template)) {
                    throw new IllegalStateException();
                }
                Template template = (Template)obj;
                String templateSuffix = template.getSuffix();
                String templateExtension = template.getExtension();
                if (!templateSuffix.equals(suffix) || !templateExtension.equals(extension)) continue;
                return template;
            }
        }
        return null;
    }

    protected Template createNewTemplate(String suffix, String extension) {
        SourceDescriptor source;
        StringBuffer name = new StringBuffer(this._pageName);
        if (StringUtil.hasValue(suffix)) {
            String separator = EngineUtil.getEngineSetting("suffixSeparator", "$");
            name.append(separator).append(suffix);
        }
        if (StringUtil.hasValue(extension)) {
            name.append(".").append(extension);
        }
        if ((source = SourceUtil.getSourceDescriptor(name.toString())).exists()) {
            TemplateImpl template = new TemplateImpl(this, suffix, extension);
            template.setSource(source);
            return template;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Template getTemplateFromFixedSuffix(String suffix, String extension) {
        if (suffix == null || extension == null) {
            throw new IllegalArgumentException();
        }
        PageImpl pageImpl = this;
        synchronized (pageImpl) {
            Template template = this.findTemplateFromCache(suffix, extension);
            if (template != null) {
                if (template.getSource().exists()) {
                    return template;
                }
                return null;
            }
            template = this.createNewTemplate(suffix, extension);
            if (template == null) {
                return null;
            }
            if (this._templates == null) {
                this._templates = new ArrayList();
            }
            this._templates.add(new SoftReference<Template>(template));
            return template;
        }
    }

    public Template getTemplate(String suffix, String extension) {
        Template template;
        if (suffix == null) {
            suffix = "";
        }
        if (extension == null) {
            extension = "";
        }
        if ((template = this.getTemplateFromFixedSuffix(suffix, extension)) == null && StringUtil.hasValue(suffix)) {
            template = this.getTemplateFromFixedSuffix("", extension);
        }
        if (template == null) {
            throw new PageNotFoundException(this._pageName, extension);
        }
        return template;
    }

    public ProcessStatus doPageRender(String requestedSuffix, String extension) {
        return RenderUtil.renderPage(true, this, null, this, requestedSuffix, extension);
    }

    public ProcessStatus renderTemplate(Page topLevelPage, Template[] templates) {
        if (topLevelPage == null || templates == null || templates.length == 0) {
            throw new IllegalArgumentException();
        }
        return templates[0].doTemplateRender(topLevelPage);
    }
}

