/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.cycle.Response;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.RequestScope;
import org.seasar.maya.engine.Engine;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.error.ErrorHandler;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.PageForwarded;
import org.seasar.maya.impl.engine.PageImpl;
import org.seasar.maya.impl.engine.RenderNotCompletedException;
import org.seasar.maya.impl.engine.specification.SpecificationImpl;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.source.DelaySourceDescriptor;
import org.seasar.maya.impl.source.PageSourceDescriptor;
import org.seasar.maya.impl.source.SourceUtil;
import org.seasar.maya.impl.util.IOUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.source.SourceDescriptor;

public class EngineImpl
extends SpecificationImpl
implements Engine,
CONST_IMPL {
    private static final long serialVersionUID = 1428444571422324206L;
    private static final Log LOG;
    private static final String DEFAULT_SPECIFICATION = "defaultSpecification";
    private ErrorHandler _errorHandler;
    private List _pages;
    private String _defaultSpecification = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.engine.EngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        if (this._errorHandler == null) {
            throw new IllegalStateException();
        }
        return this._errorHandler;
    }

    protected Page findPageFromCache(String pageName) {
        if (this._pages != null) {
            SpecificationImpl.ChildSpecificationsIterator it = new SpecificationImpl.ChildSpecificationsIterator(this, this._pages);
            while (it.hasNext()) {
                Page page;
                String name;
                Object child = it.next();
                if (!(child instanceof Page) || !pageName.equals(name = (page = (Page)child).getPageName())) continue;
                return page;
            }
        }
        return null;
    }

    protected Page createNewPage(String pageName) {
        PageImpl page = new PageImpl(pageName);
        String path = String.valueOf(pageName) + ".maya";
        SourceDescriptor source = SourceUtil.getSourceDescriptor(path);
        page.setSource(source);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String pageName) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            Page page = this.findPageFromCache(pageName);
            if (page == null) {
                page = this.createNewPage(pageName);
                if (this._pages == null) {
                    this._pages = new ArrayList();
                }
                this._pages.add(new SoftReference<Page>(page));
            }
            return page;
        }
    }

    protected boolean isPageRequested() {
        RequestScope request = CycleUtil.getRequestScope();
        if ("maya".equals(request.getExtension())) {
            return true;
        }
        String mimeType = request.getMimeType();
        return mimeType != null && (mimeType.indexOf("html") != -1 || mimeType.indexOf("xml") != -1);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Throwable removeWrapperRuntimeException(Throwable t) {
        Class<?> clazz;
        Class<?> clazz2;
        Throwable throwable = t;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                if (throwable.getCause() == null) {
                    return throwable;
                }
                throwable = throwable.getCause();
            }
            clazz2 = throwable.getClass();
            clazz = class$1;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("java.lang.RuntimeException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz2.equals(clazz));
        return throwable;
    }

    public void handleError(Throwable t, boolean pageFlush) {
        t = this.removeWrapperRuntimeException(t);
        try {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            cycle.setHandledError(t);
            this.getErrorHandler().doErrorHandle(t, pageFlush);
            cycle.setHandledError(null);
        }
        catch (Throwable internal) {
            if (LOG.isFatalEnabled()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.maya.impl.engine.EngineImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String fatalMsg = StringUtil.getMessage((Class)clazz, 0, internal.getMessage());
                LOG.fatal((Object)fatalMsg, internal);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected void saveToCycle() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setOriginalNode(this);
        cycle.setInjectedNode(this);
    }

    protected void doPageService(ServiceCycle cycle, boolean pageFlush) {
        try {
            boolean service = true;
            while (service) {
                try {
                    this.saveToCycle();
                    SpecificationUtil.initScope();
                    SpecificationUtil.startScope(null);
                    SpecificationUtil.execEvent(this, QM_BEFORE_RENDER);
                    RequestScope request = cycle.getRequestScope();
                    String pageName = request.getPageName();
                    String requestedSuffix = request.getRequestedSuffix();
                    String extension = request.getExtension();
                    Page page = this.getPage(pageName);
                    ProcessStatus ret = page.doPageRender(requestedSuffix, extension);
                    this.saveToCycle();
                    SpecificationUtil.execEvent(this, QM_AFTER_RENDER);
                    SpecificationUtil.endScope();
                    Response response = CycleUtil.getResponse();
                    if (ret == null && !response.getWriter().isDirty()) {
                        throw new RenderNotCompletedException(pageName, extension);
                    }
                    if (pageFlush) {
                        response.flush();
                    }
                    service = false;
                }
                catch (PageForwarded pageForwarded) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            cycle.getResponse().clearBuffer();
            SpecificationUtil.initScope();
            this.handleError(t, pageFlush);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doResourceService(ServiceCycle cycle) {
        if (cycle == null) {
            throw new IllegalArgumentException();
        }
        String path = cycle.getRequestScope().getRequestedPath();
        PageSourceDescriptor source = new PageSourceDescriptor();
        source.setSystemID(path);
        InputStream stream = source.getInputStream();
        if (stream == null) {
            cycle.getResponse().setStatus(404);
            return;
        }
        OutputStream out = cycle.getResponse().getOutputStream();
        try {
            try {
                int i = stream.read();
                while (true) {
                    block8: {
                        if (i != -1) break block8;
                        out.flush();
                        break;
                    }
                    out.write(i);
                    i = stream.read();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            IOUtil.close(stream);
            throw throwable;
        }
        {
            Object var7_10 = null;
            IOUtil.close(stream);
            return;
        }
    }

    public void doService(boolean pageFlush) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        if (this.isPageRequested()) {
            this.doPageService(cycle, pageFlush);
        } else {
            this.doResourceService(cycle);
        }
    }

    public void setParameter(String name, String value) {
        if (DEFAULT_SPECIFICATION.equals(name)) {
            DelaySourceDescriptor source = new DelaySourceDescriptor();
            source.setSystemID(value);
            this.setSource(source);
            this._defaultSpecification = value;
        }
        super.setParameter(name, value);
    }

    public String getParameter(String name) {
        if (DEFAULT_SPECIFICATION.equals(name)) {
            return this._defaultSpecification;
        }
        return super.getParameter(name);
    }
}

