/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.web;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.seasar.maya.impl.cycle.AbstractResponse;
import org.seasar.maya.impl.util.StringUtil;

public class ResponseImpl
extends AbstractResponse {
    private static final long serialVersionUID = -4653384671998376182L;
    private HttpServletResponse _httpServletResponse;

    protected void check() {
        if (this._httpServletResponse == null) {
            throw new IllegalStateException();
        }
    }

    public void redirect(String url) {
        this.check();
        try {
            this._httpServletResponse.sendRedirect(url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setContentTypeToUnderlyingObject(String contentType) {
        this.check();
        if (StringUtil.isEmpty(contentType)) {
            throw new IllegalArgumentException();
        }
        this._httpServletResponse.setContentType(contentType);
    }

    public void addHeader(String name, String value) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this._httpServletResponse.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this._httpServletResponse.setHeader(name, value);
    }

    public void setStatus(int code) {
        this.check();
        this._httpServletResponse.setStatus(code);
    }

    public OutputStream getOutputStream() {
        this.check();
        try {
            return this._httpServletResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String encodeURL(String url) {
        this.check();
        if (StringUtil.isEmpty(url)) {
            throw new IllegalArgumentException();
        }
        return this._httpServletResponse.encodeURL(url);
    }

    public void setUnderlyingContext(Object context) {
        if (context == null || !(context instanceof HttpServletResponse)) {
            throw new IllegalArgumentException();
        }
        this._httpServletResponse = (HttpServletResponse)context;
        this.clearBuffer();
    }

    public Object getUnderlyingContext() {
        this.check();
        return this._httpServletResponse;
    }
}

