/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.script.rhino;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.seasar.maya.PositionAware;
import org.seasar.maya.cycle.scope.AttributeScope;
import org.seasar.maya.impl.cycle.script.AbstractTextCompiledScript;
import org.seasar.maya.impl.cycle.script.ReadOnlyScriptBlockException;
import org.seasar.maya.impl.cycle.script.rhino.RhinoUtil;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;

public class TextCompiledScriptImpl
extends AbstractTextCompiledScript {
    private static final long serialVersionUID = 4793923040332838492L;
    private String _sourceName;
    int _lineNumber;
    private WrapFactory _wrap;
    private Script _rhinoScript;
    private Script _elRhinoScript;
    private String _elScriptText;
    private String _elStyleName;
    private boolean _elStyle;

    public TextCompiledScriptImpl(String text, WrapFactory wrap, PositionAware position) {
        super(text);
        this._wrap = wrap;
        this._sourceName = position.getSystemID();
        this._lineNumber = position.getLineNumber();
        this.processText(text);
    }

    protected boolean maybeELStyle(String text) {
        boolean start = true;
        int i = 0;
        while (i < text.length()) {
            block8: {
                char c;
                block7: {
                    block6: {
                        c = text.charAt(i);
                        if (!start) break block6;
                        if (!Character.isJavaIdentifierStart(c)) break block7;
                        start = false;
                        break block8;
                    }
                    if (Character.isJavaIdentifierPart(c)) break block8;
                }
                if (c == '.') {
                    start = true;
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected void processText(String text) {
        int pos;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        String script = text = text.trim();
        String name = null;
        if (this.maybeELStyle(text) && (pos = text.lastIndexOf(46)) != -1 && pos != text.length() - 1) {
            script = text.substring(0, pos);
            name = text.substring(pos + 1);
        }
        this._elScriptText = script;
        this._elStyleName = name;
        this._elStyle = name != null;
    }

    protected Object normalExecute(Context cx, Scriptable scope) {
        if (cx == null || scope == null) {
            throw new IllegalArgumentException();
        }
        if (this._rhinoScript == null) {
            this._rhinoScript = cx.compileString(this.getText(), this._sourceName, this._lineNumber, null);
        }
        return this._rhinoScript.exec(cx, scope);
    }

    protected Object getELStyleHost(Context cx, Scriptable scope) {
        if (cx == null || scope == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.isEmpty(this._elScriptText)) {
            return null;
        }
        if (this._elRhinoScript == null) {
            this._elRhinoScript = cx.compileString(this._elScriptText, this._sourceName, this._lineNumber, null);
        }
        return this._elRhinoScript.exec(cx, scope);
    }

    protected Object functionExecute(Context cx, Scriptable scope, Object host, Object[] args) {
        if (cx == null || scope == null || host == null || args == null) {
            throw new IllegalArgumentException();
        }
        if (host instanceof Scriptable) {
            Object func = ((Scriptable)host).get(this._elStyleName, scope);
            return ((Function)func).call(cx, scope, (Scriptable)host, args);
        }
        Class[] argClasses = this.getMethodArgClasses();
        return ObjectUtil.invoke(host, this._elStyleName, args, argClasses);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object[] args) {
        Context cx = RhinoUtil.enter(this._wrap);
        Object ret = null;
        try {
            try {
                Object jsRet;
                Scriptable scope = RhinoUtil.getScope();
                if (this._elStyle && args != null) {
                    Object host = this.getELStyleHost(cx, scope);
                    jsRet = this.functionExecute(cx, scope, host, args);
                } else {
                    jsRet = this.normalExecute(cx, scope);
                }
                ret = RhinoUtil.convertResult(cx, this.getExpectedClass(), jsRet);
            }
            catch (WrappedException e) {
                RhinoUtil.removeWrappedException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        Context.exit();
        return ret;
    }

    public boolean isReadOnly() {
        return !this._elStyle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void assignValue(Object value) {
        if (this.isReadOnly()) {
            throw new ReadOnlyScriptBlockException(this.getScriptText());
        }
        Context cx = RhinoUtil.enter(this._wrap);
        try {
            block9: {
                try {
                    Scriptable scope = RhinoUtil.getScope();
                    if (!this._elStyle) throw new IllegalStateException();
                    Object host = this.getELStyleHost(cx, scope);
                    if (host == null) {
                        scope.put(this._elStyleName, scope, value);
                        break block9;
                    }
                    if (host instanceof Scriptable) {
                        ((Scriptable)host).put(this._elStyleName, scope, value);
                        break block9;
                    }
                    if (host instanceof AttributeScope) {
                        ((AttributeScope)host).setAttribute(this._elStyleName, value);
                        break block9;
                    }
                    ObjectUtil.setProperty(host, this._elStyleName, value);
                }
                catch (WrappedException e) {
                    RhinoUtil.removeWrappedException(e);
                }
            }
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }
}

