/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.script.rhino;

import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.seasar.maya.PositionAware;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.ApplicationScope;
import org.seasar.maya.cycle.scope.AttributeScope;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.impl.IllegalParameterValueException;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.cycle.script.AbstractScriptEnvironment;
import org.seasar.maya.impl.cycle.script.LiteralScript;
import org.seasar.maya.impl.cycle.script.ScriptBlock;
import org.seasar.maya.impl.cycle.script.rhino.PageAttributeScope;
import org.seasar.maya.impl.cycle.script.rhino.SourceCompiledScriptImpl;
import org.seasar.maya.impl.cycle.script.rhino.TextCompiledScriptImpl;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.source.SourceDescriptor;

public class ScriptEnvironmentImpl
extends AbstractScriptEnvironment {
    private static Scriptable _standardObjects;
    private static ThreadLocal _parent;
    private WrapFactory _wrap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        _parent = new ThreadLocal();
    }

    protected CompiledScript compile(ScriptBlock scriptBlock, PositionAware position) {
        if (scriptBlock == null) {
            throw new IllegalArgumentException();
        }
        String text = scriptBlock.getBlockString();
        if (scriptBlock.isLiteral()) {
            return new LiteralScript(text);
        }
        return new TextCompiledScriptImpl(text, this._wrap, position);
    }

    protected String getSourceMimeType(SourceDescriptor source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        String systemID = source.getSystemID();
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        ApplicationScope application = cycle.getApplicationScope();
        return application.getMimeType(systemID);
    }

    public CompiledScript compile(SourceDescriptor source, String encoding) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        return new SourceCompiledScriptImpl(source, encoding, this._wrap);
    }

    protected Scriptable getStandardObjects() {
        if (_standardObjects == null) {
            Context cx = Context.enter();
            _standardObjects = cx.initStandardObjects(null, true);
            Context.exit();
        }
        return _standardObjects;
    }

    public void initScope() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setPageScope(null);
        _parent.set(null);
    }

    public void startScope(Map variables) {
        Object parent;
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope scope = cycle.getPageScope();
        if (scope == null) {
            parent = (Scriptable)_parent.get();
            if (parent == null) {
                Context cx = Context.enter();
                if (this._wrap != null) {
                    cx.setWrapFactory(this._wrap);
                }
                Scriptable standard = this.getStandardObjects();
                WrapFactory wrapFactory = cx.getWrapFactory();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.seasar.maya.cycle.ServiceCycle");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                parent = wrapFactory.wrapAsJavaObject(cx, standard, (Object)cycle, (Class)clazz);
                Context.exit();
                _parent.set(parent);
            }
        } else if (scope instanceof PageAttributeScope) {
            parent = (PageAttributeScope)scope;
        } else {
            throw new IllegalStateException();
        }
        PageAttributeScope pageScope = new PageAttributeScope();
        pageScope.setParentScope((Scriptable)parent);
        if (variables != null) {
            Iterator it = variables.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next().toString();
                Object value = variables.get(name);
                Object variable = Context.javaToJS(value, (Scriptable)pageScope);
                ScriptableObject.putProperty((Scriptable)pageScope, (String)name, (Object)variable);
            }
        }
        cycle.setPageScope(pageScope);
    }

    public void endScope() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope scope = cycle.getPageScope();
        if (scope instanceof PageAttributeScope) {
            PageAttributeScope pageScope = (PageAttributeScope)scope;
            Scriptable current = pageScope.getParentScope();
            if (current instanceof PageAttributeScope) {
                PageAttributeScope parentScope = (PageAttributeScope)current;
                cycle.setPageScope(parentScope);
                return;
            }
            if (current != null) {
                cycle.setPageScope(null);
                return;
            }
        }
        throw new IllegalStateException();
    }

    public Object convertFromScriptObject(Object scriptObject) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaAdapter.convertResult((Object)scriptObject, (Class)clazz);
    }

    public void setParameter(String name, String value) {
        if ("wrapFactory".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.mozilla.javascript.WrapFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class clazz2 = ObjectUtil.loadClass(value, clazz);
            this._wrap = (WrapFactory)ObjectUtil.newInstance(clazz2);
        } else if ("blockSign".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this.setBlockSign(value);
        }
        super.setParameter(name, value);
    }
}

