/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.AttributeScope;

public class ScopeIterator
implements Iterator {
    private ServiceCycle _cycle;
    private Iterator _it;
    private String _current;

    public ScopeIterator(ServiceCycle cycle, Iterator it) {
        if (cycle == null || it == null) {
            throw new IllegalArgumentException();
        }
        this._cycle = cycle;
        this._it = it;
    }

    public boolean hasNext() {
        return !"application".equals(this._current);
    }

    public Object next() {
        AttributeScope scope = null;
        if (this._current == null) {
            AttributeScope page = this._cycle.getPageScope();
            if (page != null) {
                scope = page;
                this._current = "page";
            } else if (this._it.hasNext()) {
                scope = (AttributeScope)this._it.next();
                this._current = scope.getScopeName();
            }
        } else if ("request".equals(this._current)) {
            scope = this._cycle.getSessionScope();
            this._current = "session";
        } else if ("session".equals(this._current)) {
            scope = this._cycle.getApplicationScope();
            this._current = "application";
        } else {
            if ("application".equals(this._current)) {
                throw new NoSuchElementException();
            }
            if (this._it.hasNext()) {
                scope = (AttributeScope)this._it.next();
                this._current = scope.getScopeName();
            } else {
                scope = this._cycle.getRequestScope();
                this._current = "request";
            }
        }
        return scope;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

