/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library.mld;

import org.seasar.maya.ParameterAware;
import org.seasar.maya.impl.builder.library.LibraryDefinitionImpl;
import org.seasar.maya.impl.builder.library.ProcessorDefinitionImpl;
import org.seasar.maya.impl.builder.library.PropertySetImpl;
import org.seasar.maya.impl.builder.library.mld.LibraryTagHandler;
import org.seasar.maya.impl.builder.library.mld.ProcessorTagHandler;
import org.seasar.maya.impl.builder.library.mld.PropertyTagHandler;
import org.seasar.maya.impl.provider.factory.AbstractParameterAwareTagHandler;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.xml.TagHandler;
import org.xml.sax.Attributes;

public class PropertySetTagHandler
extends AbstractParameterAwareTagHandler {
    private TagHandler _parent;
    private LibraryTagHandler _libraryTagHandler;
    private PropertySetImpl _propertySet;

    public PropertySetTagHandler(String name, TagHandler parent, LibraryTagHandler libraryTagHandler) {
        super(name);
        if (parent == null || libraryTagHandler == null) {
            throw new IllegalArgumentException();
        }
        this._parent = parent;
        this._libraryTagHandler = libraryTagHandler;
        this.putHandler(new PropertyTagHandler(this, libraryTagHandler));
    }

    protected PropertySetImpl createPropertySet() {
        return new PropertySetImpl();
    }

    protected void start(Attributes attributes, String systemID, int lineNumber) {
        String name = attributes.getValue("name");
        if (StringUtil.isEmpty(name)) {
            throw new IllegalStateException();
        }
        this._propertySet = this.createPropertySet();
        if (this._propertySet == null) {
            throw new IllegalStateException();
        }
        this._propertySet.setName(name);
        this._propertySet.setSystemID(systemID);
        this._propertySet.setLineNumber(lineNumber);
    }

    protected void addToLibrary(LibraryDefinitionImpl library) {
        if (this._parent instanceof ProcessorTagHandler) {
            ProcessorDefinitionImpl processorDef = ((ProcessorTagHandler)this._parent).getProcessorDefinition();
            processorDef.addPropertySetRef(this._propertySet.getName(), this._propertySet.getSystemID(), this._propertySet.getLineNumber());
        }
        if (this._propertySet.iteratePropertyDefinition().hasNext()) {
            library.addPropertySet(this._propertySet);
        }
    }

    protected void end(String body) {
        LibraryDefinitionImpl library = this._libraryTagHandler.getLibraryDefinition();
        this._propertySet.setLibraryDefinition(library);
        this.addToLibrary(library);
        this._propertySet = null;
    }

    public PropertySetImpl getPropertySet() {
        if (this._propertySet == null) {
            throw new IllegalStateException();
        }
        return this._propertySet;
    }

    public ParameterAware getParameterAware() {
        throw new IllegalStateException();
    }
}

