/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.builder.library.LibraryDefinition;
import org.seasar.maya.builder.library.LibraryManager;
import org.seasar.maya.builder.library.ProcessorDefinition;
import org.seasar.maya.builder.library.PropertyDefinition;
import org.seasar.maya.builder.library.PropertySet;
import org.seasar.maya.builder.library.converter.PropertyConverter;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.library.ConverterNotFoundException;
import org.seasar.maya.impl.builder.library.FinalProcessorPropertyException;
import org.seasar.maya.impl.builder.library.NoRequiredPropertyException;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;

public class PropertyDefinitionImpl
extends ParameterAwareImpl
implements PropertyDefinition,
CONST_IMPL {
    private static final Log LOG;
    private PropertySet _propertySet;
    private String _name;
    private boolean _required;
    private Class _expectedClass;
    private String _defaultValue;
    private String _finalValue;
    private String _propertyConverterName;
    private PropertyConverter _propertyConverter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.PropertyDefinitionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void setPropertySet(PropertySet propertySet) {
        if (propertySet == null) {
            throw new IllegalArgumentException();
        }
        this._propertySet = propertySet;
    }

    public PropertySet getPropertySet() {
        if (this._propertySet == null) {
            throw new IllegalStateException();
        }
        return this._propertySet;
    }

    public void setName(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    public String getName() {
        if (StringUtil.isEmpty(this._name)) {
            throw new IllegalStateException();
        }
        return this._name;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setExpectedClass(Class expectedClass) {
        this._expectedClass = expectedClass;
    }

    public Class getExpectedClass() {
        if (this._expectedClass == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        return this._expectedClass;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setFinalValue(String finalValue) {
        this._finalValue = finalValue;
    }

    public String getFinalValue() {
        return this._finalValue;
    }

    public void setPropertyConverterName(String propertyConverterName) {
        this._propertyConverterName = propertyConverterName;
    }

    public String getPropertyConverterName() {
        return this._propertyConverterName;
    }

    public void setPropertyConverter(PropertyConverter propertyConverter) {
        if (propertyConverter == null) {
            throw new IllegalArgumentException();
        }
        this._propertyConverter = propertyConverter;
    }

    protected PropertyConverter getPropertyConverter(ProcessorDefinition processorDef) {
        if (this._propertyConverter != null) {
            return this._propertyConverter;
        }
        LibraryDefinition library = this.getPropertySet().getLibraryDefinition();
        String converterName = this.getPropertyConverterName();
        if (StringUtil.hasValue(converterName)) {
            PropertyConverter converter = library.getPropertyConverter(converterName);
            if (converter == null) {
                throw new ConverterNotFoundException(converterName, this.getSystemID(), this.getLineNumber());
            }
            return converter;
        }
        Class propertyClass = this.getPropertyClass(processorDef);
        if (propertyClass != null) {
            return library.getPropertyConverter(propertyClass);
        }
        return null;
    }

    protected Class getPropertyClass(ProcessorDefinition processorDef) {
        Class processorClass = processorDef.getProcessorClass();
        return ObjectUtil.getPropertyClass(processorClass, this.getName());
    }

    protected QName getQName(SpecificationNode injected) {
        return SpecificationUtil.createQName(injected.getQName().getNamespaceURI(), this._name);
    }

    public Object createProcessorProperty(ProcessorDefinition processorDef, SpecificationNode injected) {
        if (injected == null) {
            throw new IllegalArgumentException();
        }
        QName qName = this.getQName(injected);
        String value = this.getFinalValue();
        NodeAttribute attribute = injected.getAttribute(qName);
        if (value == null) {
            value = this.getDefaultValue();
            if (attribute != null) {
                value = attribute.getValue();
            }
        } else if (attribute != null) {
            String processorName = processorDef.getName();
            throw new FinalProcessorPropertyException(processorName, qName);
        }
        if (value != null) {
            PropertyConverter converter;
            Class propertyClass = this.getPropertyClass(processorDef);
            if (propertyClass == null) {
                Class processotClass = processorDef.getProcessorClass();
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.seasar.maya.engine.processor.VirtualPropertyAcceptable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(processotClass)) {
                    if (LOG.isWarnEnabled()) {
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("org.seasar.maya.impl.builder.library.PropertyDefinitionImpl");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        LOG.warn((Object)StringUtil.getMessage(clazz2, 0, processorDef.getName(), this.getName()));
                    }
                    return null;
                }
            }
            if ((converter = this.getPropertyConverter(processorDef)) == null && propertyClass != null) {
                LibraryManager manager = ProviderUtil.getLibraryManager();
                converter = manager.getPropertyConverter(propertyClass);
            }
            if (converter == null) {
                return value;
            }
            return converter.convert(attribute, value, this.getExpectedClass());
        }
        if (this._required) {
            String processorName = processorDef.getName();
            throw new NoRequiredPropertyException(processorName, qName);
        }
        return null;
    }
}

