/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.maya.PositionAware;
import org.seasar.maya.builder.library.DefinitionBuilder;
import org.seasar.maya.builder.library.LibraryDefinition;
import org.seasar.maya.builder.library.LibraryManager;
import org.seasar.maya.builder.library.ProcessorDefinition;
import org.seasar.maya.builder.library.converter.PropertyConverter;
import org.seasar.maya.builder.library.scanner.SourceScanner;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.AbstractScanningIterator;
import org.seasar.maya.source.SourceDescriptor;

public class LibraryManagerImpl
extends ParameterAwareImpl
implements LibraryManager {
    private static Log LOG;
    private List _scanners = new ArrayList();
    private List _builders = new ArrayList();
    private List _libraries;
    private Map _converters = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.LibraryManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    protected void warnAlreadyRegisted(PositionAware obj, String name, int index) {
        if (LOG.isWarnEnabled()) {
            String systemID = obj.getSystemID();
            String lineNumber = Integer.toString(obj.getLineNumber());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.maya.impl.builder.library.LibraryManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LOG.warn((Object)StringUtil.getMessage(clazz, index, name, systemID, lineNumber));
        }
    }

    public void addPropertyConverter(String name, PropertyConverter propertyConverter) {
        if (propertyConverter == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.isEmpty(name)) {
            name = propertyConverter.getPropetyClass().getName();
        }
        if (this._converters.containsKey(name)) {
            this.warnAlreadyRegisted(propertyConverter, name, 1);
        } else {
            this._converters.put(name, propertyConverter);
        }
    }

    public PropertyConverter getPropertyConverter(String converterName) {
        if (StringUtil.isEmpty(converterName)) {
            throw new IllegalArgumentException();
        }
        return (PropertyConverter)this._converters.get(converterName);
    }

    public PropertyConverter getPropertyConverter(Class propertyClass) {
        if (propertyClass == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = this._converters.values().iterator();
        while (it.hasNext()) {
            PropertyConverter propertyConverter = (PropertyConverter)it.next();
            Class converterClass = propertyConverter.getPropetyClass();
            if (!propertyClass.isAssignableFrom(converterClass)) continue;
            return propertyConverter;
        }
        return null;
    }

    public Iterator iteratePropertyConverters() {
        return this._converters.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceScanner(SourceScanner scanner) {
        if (scanner == null) {
            throw new IllegalArgumentException();
        }
        List list = this._scanners;
        synchronized (list) {
            if (this._scanners.contains(scanner)) {
                this.warnAlreadyRegisted(scanner, scanner.getClass().getName(), 1);
            } else {
                this._scanners.add(scanner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinitionBuilder(DefinitionBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException();
        }
        List list = this._builders;
        synchronized (list) {
            if (this._builders.contains(builder)) {
                this.warnAlreadyRegisted(builder, builder.getClass().getName(), 3);
            } else {
                this._builders.add(builder);
            }
        }
    }

    protected void buildAll() {
        this._libraries = new ArrayList();
        HashSet<String> systemIDs = new HashSet<String>();
        int i = 0;
        while (i < this._scanners.size()) {
            SourceScanner scanner = (SourceScanner)this._scanners.get(i);
            Iterator it = scanner.scan();
            block3: while (it.hasNext()) {
                SourceDescriptor source = (SourceDescriptor)it.next();
                int k = 0;
                while (k < this._builders.size()) {
                    DefinitionBuilder builder = (DefinitionBuilder)this._builders.get(k);
                    LibraryDefinition library = builder.build(source);
                    if (library != null) {
                        this._libraries.add(library);
                        systemIDs.add(library.getSystemID());
                        if (!LOG.isInfoEnabled()) continue block3;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.seasar.maya.impl.builder.library.LibraryManagerImpl");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        LOG.info((Object)StringUtil.getMessage(clazz, 4, source.getSystemID(), library.getNamespaceURI()));
                        continue block3;
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public Iterator iterateLibraryDefinition() {
        if (this._libraries == null) {
            this.buildAll();
        }
        return this._libraries.iterator();
    }

    public Iterator iterateLibraryDefinition(String namespaceURI) {
        if (StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        return new LibraryDefinitionFilteredIterator(namespaceURI, this.iterateLibraryDefinition());
    }

    public ProcessorDefinition getProcessorDefinition(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException();
        }
        String namespaceURI = qName.getNamespaceURI();
        String localName = qName.getLocalName();
        Iterator it = this.iterateLibraryDefinition(namespaceURI);
        while (it.hasNext()) {
            LibraryDefinition library = (LibraryDefinition)it.next();
            ProcessorDefinition processor = library.getProcessorDefinition(localName);
            if (processor == null) continue;
            return processor;
        }
        return null;
    }

    private class LibraryDefinitionFilteredIterator
    extends AbstractScanningIterator {
        private String _namespaceURI;

        public LibraryDefinitionFilteredIterator(String namespaceURI, Iterator iterator) {
            super(iterator);
            if (StringUtil.isEmpty(namespaceURI)) {
                throw new IllegalArgumentException();
            }
            this._namespaceURI = namespaceURI;
        }

        protected boolean filter(Object test) {
            if (test == null || !(test instanceof LibraryDefinition)) {
                return false;
            }
            LibraryDefinition library = (LibraryDefinition)test;
            if (this._namespaceURI.equals(library.getNamespaceURI())) {
                return true;
            }
            Iterator it = library.iterateAssignedURI();
            while (it.hasNext()) {
                if (!this._namespaceURI.equals(it.next())) continue;
                return true;
            }
            return false;
        }
    }
}

