/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.builder.injection;

import org.seasar.maya.builder.injection.InjectionChain;
import org.seasar.maya.builder.injection.InjectionResolver;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.builder.BuilderUtil;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.ObjectUtil;
import org.seasar.maya.impl.util.StringUtil;

public class ReplaceSetter
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    protected static final QName QM_REPLACE = SpecificationUtil.createQName("replace");

    protected boolean isReplace(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        NodeAttribute attr = node.getAttribute(QM_REPLACE);
        if (attr != null) {
            return ObjectUtil.booleanValue(attr.getValue(), true);
        }
        return true;
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        SpecificationNode injected = chain.getNode(original);
        if (injected == null) {
            return null;
        }
        if (!this.isReplace(original) || !this.isReplace(injected)) {
            QName qName = original.getQName();
            String uri = qName.getNamespaceURI();
            SpecificationNode element = BuilderUtil.createInjectedNode(QM_DUPLECATED, uri, original, false);
            StringBuffer name = new StringBuffer();
            String prefix = original.getPrefix();
            if (StringUtil.hasValue(prefix)) {
                name.append(prefix).append(":");
            }
            name.append(qName.getLocalName());
            element.addAttribute(QM_NAME, name.toString());
            element.addChildNode(injected);
            return element;
        }
        return injected;
    }
}

