/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.seasar.maya.ParameterAware;
import org.seasar.maya.impl.IllegalParameterValueException;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.NullIterator;

public class ParameterAwareImpl
implements ParameterAware {
    private Map _parameters;
    private String _systemID = "";
    private int _lineNumber;
    private boolean _onTemplate;

    public void setParameter(String name, String value) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalParameterValueException(this.getClass(), name);
        }
        if (this._parameters == null) {
            this._parameters = new HashMap();
        }
        this._parameters.put(name, value);
    }

    public String getParameter(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._parameters == null) {
            return null;
        }
        return (String)this._parameters.get(name);
    }

    public Iterator iterateParameterNames() {
        if (this._parameters == null) {
            return NullIterator.getInstance();
        }
        return this._parameters.keySet().iterator();
    }

    public void setSystemID(String systemID) {
        this._systemID = StringUtil.preparePath(systemID);
    }

    public String getSystemID() {
        return this._systemID;
    }

    public void setLineNumber(int lineNumber) {
        if (lineNumber < 0) {
            lineNumber = 0;
        }
        this._lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setOnTemplate(boolean onTemplate) {
        this._onTemplate = onTemplate;
    }

    public boolean isOnTemplate() {
        return this._onTemplate;
    }
}

