/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.seasar.maya.UnifiedFactory;
import org.seasar.maya.source.SourceDescriptor;

public abstract class FactoryFactory
implements Serializable {
    private static FactoryFactory _instance;
    private static Object _context;
    private static Map _factories;

    static {
        _factories = new HashMap();
    }

    public static void setInstance(FactoryFactory instance) {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        _instance = instance;
    }

    public static void setContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        _context = context;
    }

    private static void check() {
        if (_instance == null || _context == null) {
            throw new IllegalStateException();
        }
    }

    public static SourceDescriptor getBootstrapSource(String systemID) {
        FactoryFactory.check();
        return _instance.getBootstrapSource(systemID, _context);
    }

    public static UnifiedFactory getFactory(Class interfaceClass) {
        FactoryFactory.check();
        UnifiedFactory factory = (UnifiedFactory)_factories.get(interfaceClass);
        if (factory == null) {
            factory = _instance.getFactory(interfaceClass, _context);
            if (factory == null) {
                throw new IllegalStateException();
            }
            _factories.put(interfaceClass, factory);
        }
        return factory;
    }

    protected abstract UnifiedFactory getFactory(Class var1, Object var2);

    protected abstract SourceDescriptor getBootstrapSource(String var1, Object var2);
}

