package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.component.html.HtmlTitle;
import org.seasar.jsf.taglib.UIComponentTagBase;

public class HtmlTitleTag extends UIComponentTagBase {

	private String value;
	
	public void setValue(String value) {
		this.value = value;
	}
	
	public String getComponentType() {
		return HtmlTitle.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return HtmlTitle.DEFAULT_RENDERER_TYPE;
	}
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		setComponentProperty(component, JsfConstants.VALUE_ATTR, value);
	}
	
	public void release() {
		super.release();
		value = null;
	}
}