package org.seasar.jsf.component;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

/**
 * @author higa
 *  
 */
public class UIText extends UIComponentBase {

	public static final String COMPONENT_TYPE = "org.seasar.jsf.Text";

	public static final String COMPONENT_FAMILY = "javax.faces.Output";

	public static final String DEFAULT_RENDERER_TYPE = "org.seasar.jsf.Text";

	private String value;

	public UIText() {
		setRendererType(DEFAULT_RENDERER_TYPE);
	}
	
	public String getValue() {
		return value;
	}
	
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @see javax.faces.component.UIComponent#getFamily()
	 */
	public String getFamily() {
		return COMPONENT_FAMILY;
	}
	
	public Object saveState(FacesContext context) {
		Object[] values = new Object[2];
		values[0] = super.saveState(context);
		values[1] = value;
		return values;
	}

	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		value = (String) values[1];
	}
}