/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public final class UIComponentUtil {
    private UIComponentUtil() {
    }

    public static UIComponent findParent(UIComponent component, Class parentClass) {
        UIComponent parent = component.getParent();
        while (parent != null) {
            if (parentClass.isInstance(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        throw new IllegalArgumentException(parentClass.getName());
    }

    public static String getLabel(UIComponent component) {
        String label = (String)component.getAttributes().get("label");
        if (label != null) {
            return label;
        }
        return component.getId();
    }

    public static void callValidators(FacesContext context, UIInput input, Object convertedValue) {
        FacesMessage facesMessage;
        Validator[] validators = input.getValidators();
        int i = 0;
        while (i < validators.length) {
            block8: {
                Validator validator = validators[i];
                try {
                    validator.validate(context, (UIComponent)input, convertedValue);
                }
                catch (ValidatorException e) {
                    input.setValid(false);
                    facesMessage = e.getFacesMessage();
                    if (facesMessage == null) break block8;
                    context.addMessage(input.getClientId(context), facesMessage);
                }
            }
            ++i;
        }
        MethodBinding validatorBinding = input.getValidator();
        if (validatorBinding != null) {
            try {
                validatorBinding.invoke(context, new Object[]{context, input, convertedValue});
            }
            catch (EvaluationException e) {
                input.setValid(false);
                Throwable cause = e.getCause();
                if (cause instanceof ValidatorException) {
                    facesMessage = ((ValidatorException)cause).getFacesMessage();
                    if (facesMessage != null) {
                        context.addMessage(input.getClientId(context), facesMessage);
                    }
                }
                throw e;
            }
        }
    }
}

