/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.seasar.framework.container.autoregister.AbstractComponentAutoRegister;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.JarInputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractJarComponentAutoRegister
extends AbstractComponentAutoRegister {
    private String baseDir;
    private Pattern[] jarFileNamePatterns;

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void registAll() {
        if (this.baseDir == null) {
            this.setupBaseDir();
        }
        File dir = new File(this.baseDir);
        String[] jars = dir.list();
        int i = 0;
        while (i < jars.length) {
            if (this.isAppliedJar(jars[i])) {
                File jarFile = this.findJar(jars[i]);
                FileInputStream is = FileInputStreamUtil.create(jarFile);
                try {
                    this.iterateJarEntry(is);
                }
                finally {
                    InputStreamUtil.close(is);
                }
            }
            ++i;
        }
    }

    protected abstract void setupBaseDir();

    protected boolean isAppliedJar(String jarFileName) {
        if (this.jarFileNamePatterns == null) {
            return true;
        }
        String name = ResourceUtil.removeExtension(jarFileName);
        int i = 0;
        while (i < this.jarFileNamePatterns.length) {
            if (this.jarFileNamePatterns[i].matcher(name).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected File findJar(String jarFileName) {
        return new File(this.baseDir, jarFileName);
    }

    protected void iterateJarEntry(InputStream is) {
        JarInputStream jarIs = JarInputStreamUtil.create(is);
        try {
            JarEntry entry;
            while ((entry = JarInputStreamUtil.getNextJarEntry(jarIs)) != null) {
                this.processEntry(entry.getName());
            }
        }
        finally {
            InputStreamUtil.close(jarIs);
        }
    }

    protected void processEntry(String entryName) {
        if (!entryName.endsWith(".class")) {
            return;
        }
        String className = entryName.substring(0, entryName.length() - ".class".length()).replace('/', '.');
        int index = className.lastIndexOf(46);
        String packageName = index == -1 ? null : className.substring(0, index);
        String shortClassName = index == -1 ? className : className.substring(index + 1);
        this.applyClassPattern(packageName, shortClassName);
    }

    protected void applyClassPattern(String packageName, String shortClassName) {
        if (this.isIgnore(packageName, shortClassName)) {
            return;
        }
        int i = 0;
        while (i < this.getClassPatternSize()) {
            ClassPattern cp = this.getClassPattern(i);
            if (cp.isAppliedPackageName(packageName) && cp.isAppliedShortClassName(shortClassName)) {
                this.regist(packageName, shortClassName);
            }
            ++i;
        }
    }

    public void setJarFileNames(String jarFileNames) {
        String[] array = StringUtil.split(jarFileNames, ",");
        this.jarFileNamePatterns = new Pattern[array.length];
        int i = 0;
        while (i < array.length) {
            String s = array[i].trim();
            this.jarFileNamePatterns[i] = Pattern.compile(s);
            ++i;
        }
    }
}

