/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.timer;

import java.util.ArrayList;
import java.util.Iterator;
import org.seasar.extension.timer.TimeoutTarget;
import org.seasar.extension.timer.TimeoutTask;
import org.seasar.framework.util.SLinkedList;

public class TimeoutManager
implements Runnable {
    private static TimeoutManager _instance = new TimeoutManager();
    private Thread thread_;
    private SLinkedList timeoutTaskList_ = new SLinkedList();

    private TimeoutManager() {
        this.start();
    }

    public static TimeoutManager getInstance() {
        return _instance;
    }

    public void start() {
        this.thread_ = new Thread(this);
        this.thread_.setDaemon(true);
        this.thread_.start();
    }

    public void stop() {
        this.thread_.interrupt();
        this.thread_ = null;
    }

    public synchronized void clear() {
        this.timeoutTaskList_.clear();
    }

    public void run() {
        ArrayList<TimeoutTask> expiredTask = new ArrayList<TimeoutTask>();
        while (this.thread_ != null) {
            try {
                SLinkedList sLinkedList = this.timeoutTaskList_;
                synchronized (sLinkedList) {
                    while (this.timeoutTaskList_.isEmpty()) {
                        this.timeoutTaskList_.wait();
                    }
                    SLinkedList.Entry e = this.timeoutTaskList_.getFirstEntry();
                    while (e != null) {
                        TimeoutTask task = (TimeoutTask)e.getElement();
                        if (task.isCanceled()) {
                            e.remove();
                        } else if (!task.isStopped() && task.isExpired()) {
                            expiredTask.add(task);
                            if (!task.isPermanent()) {
                                e.remove();
                            }
                        }
                        e = e.getNext();
                    }
                }
                Iterator it = expiredTask.iterator();
                while (it.hasNext()) {
                    TimeoutTask task = (TimeoutTask)it.next();
                    task.expired();
                    if (!task.isPermanent()) continue;
                    task.restart();
                }
                expiredTask.clear();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public TimeoutTask addTimeoutTarget(TimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        TimeoutTask task = new TimeoutTask(timeoutTarget, timeout, permanent);
        SLinkedList sLinkedList = this.timeoutTaskList_;
        synchronized (sLinkedList) {
            this.timeoutTaskList_.addLast((Object)task);
            this.timeoutTaskList_.notify();
        }
        return task;
    }

    public int getTimeoutTaskCount() {
        return this.timeoutTaskList_.size();
    }
}

