/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.ListIterator;
import javassist.ClassPool;
import javassist.CtClass;
import org.seasar.framework.aop.javassist.AbstractGenerator;
import org.seasar.framework.aop.javassist.TryBlockSupport;

public class EnhancedClassGenerator
extends AbstractGenerator {
    protected final Class targetClass;
    protected final String enhancedClassName;
    protected CtClass enhancedClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public EnhancedClassGenerator(ClassPool classPool, Class targetClass, String enhancedClassName) {
        super(classPool);
        this.targetClass = targetClass;
        this.enhancedClassName = enhancedClassName;
        this.setupClass();
        this.setupInterface();
        this.setupConstructor();
    }

    public void createTargetMethod(Method method, String methodInvocationClassName) {
        this.createMethod(this.enhancedClass, method, EnhancedClassGenerator.createTargetMethodSource(method, methodInvocationClassName));
    }

    public void createInvokeSuperMethod(Method method, String invokeSuperMethodName) {
        this.createMethod(this.enhancedClass, method.getModifiers(), method.getReturnType(), invokeSuperMethodName, method.getParameterTypes(), method.getExceptionTypes(), EnhancedClassGenerator.createInvokeSuperMethodSource(method));
    }

    public Class toClass(ClassLoader classLoader) {
        Class clazz = this.toClass(classLoader, this.enhancedClass);
        this.enhancedClass.detach();
        this.enhancedClass = null;
        return clazz;
    }

    public void setupClass() {
        Class<?> clazz;
        block3: {
            block2: {
                if (!this.targetClass.isInterface()) break block2;
                clazz = class$0;
                if (clazz != null) break block3;
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                break block3;
            }
            clazz = this.targetClass;
        }
        Class<?> superClass = clazz;
        this.enhancedClass = this.createCtClass(this.enhancedClassName, superClass);
    }

    public void setupInterface() {
        if (this.targetClass.isInterface()) {
            this.setInterface(this.enhancedClass, this.targetClass);
        }
    }

    public void setupConstructor() {
        Constructor<?>[] constructors = this.targetClass.getDeclaredConstructors();
        if (constructors.length == 0) {
            this.createDefaultConstructor(this.enhancedClass);
        } else {
            int i = 0;
            while (i < constructors.length) {
                int modifier = constructors[i].getModifiers();
                Package pkg = this.targetClass.getPackage();
                if (Modifier.isPublic(modifier) || Modifier.isProtected(modifier) || !Modifier.isPrivate(modifier) && !this.targetClass.getName().startsWith("java.") && (pkg == null || !pkg.isSealed())) {
                    this.createConstructor(this.enhancedClass, constructors[i]);
                }
                ++i;
            }
        }
    }

    public static String createTargetMethodSource(Method method, String methodInvocationClassName) {
        String code;
        block14: {
            Class[] exceptionTypes;
            block13: {
                StringBuffer buf = new StringBuffer(200);
                buf.append("Object result = new ").append(methodInvocationClassName).append("(this, $args).proceed();");
                Class<?> returnType = method.getReturnType();
                if (returnType.equals(Void.TYPE)) {
                    buf.append("return;");
                } else if (returnType.isPrimitive()) {
                    buf.append("return ($r) ((result == null) ? ");
                    if (returnType.equals(Boolean.TYPE)) {
                        buf.append("false : ");
                    } else {
                        buf.append("0 : ");
                    }
                    buf.append(EnhancedClassGenerator.fromObject(returnType, "result")).append(");");
                } else {
                    buf.append("return ($r) result;");
                }
                code = new String(buf);
                exceptionTypes = EnhancedClassGenerator.normalizeExceptionTypes(method.getExceptionTypes());
                if (exceptionTypes.length != 1) break block13;
                Class clazz = exceptionTypes[0];
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("java.lang.Throwable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) break block14;
            }
            code = EnhancedClassGenerator.aroundTryCatchBlock(exceptionTypes, code);
        }
        return "{" + code + "}";
    }

    public static String createInvokeSuperMethodSource(Method method) {
        return "{return ($r) super." + method.getName() + "($$);" + "}";
    }

    public static Class[] normalizeExceptionTypes(Class[] exceptionTypes) {
        LinkedList<Class> list = new LinkedList<Class>();
        int i = 0;
        while (i < exceptionTypes.length) {
            block3: {
                Class currentException = exceptionTypes[i];
                ListIterator it = list.listIterator();
                while (it.hasNext()) {
                    Class comparisonException = (Class)it.next();
                    if (!comparisonException.isAssignableFrom(currentException)) {
                        if (!currentException.isAssignableFrom(comparisonException)) continue;
                        it.remove();
                        continue;
                    }
                    break block3;
                }
                list.add(currentException);
            }
            ++i;
        }
        return list.toArray(new Class[list.size()]);
    }

    public static String aroundTryCatchBlock(Class[] exceptionTypes, String code) {
        Class<?> clazz;
        TryBlockSupport tryBlock = new TryBlockSupport(code);
        boolean needRuntimeException = true;
        boolean needError = true;
        int i = 0;
        while (i < exceptionTypes.length) {
            Class<?> clazz2;
            Class exceptionType = exceptionTypes[i];
            tryBlock.addCatchBlock(exceptionType, "throw e;");
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = Class.forName("java.lang.RuntimeException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (exceptionType.equals(clazz3)) {
                needRuntimeException = false;
            }
            if ((clazz2 = class$5) == null) {
                try {
                    clazz2 = Class.forName("java.lang.Error");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (exceptionType.equals(clazz2)) {
                needError = false;
            }
            ++i;
        }
        if (needRuntimeException) {
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("java.lang.RuntimeException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            tryBlock.addCatchBlock(clazz4, "throw e;");
        }
        if (needError) {
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("java.lang.Error");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            tryBlock.addCatchBlock(clazz5, "throw e;");
        }
        if ((clazz = class$3) == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Throwable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        tryBlock.addCatchBlock(clazz, "throw new java.lang.reflect.UndeclaredThrowableException(e);");
        return tryBlock.getSourceCode();
    }
}

