/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.util.regex.Pattern;
import org.seasar.framework.util.StringUtil;

public class ClassPattern {
    private String packageName;
    private Pattern[] shortClassNamePatterns;

    public ClassPattern() {
    }

    public ClassPattern(String packageName, String shortClassName) {
        this.setPackageName(packageName);
        this.setShortClassName(shortClassName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setShortClassName(String shortClassName) {
        String[] classNames = StringUtil.split(shortClassName, ",");
        this.shortClassNamePatterns = new Pattern[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            String s = classNames[i].trim();
            this.shortClassNamePatterns[i] = Pattern.compile(s);
            ++i;
        }
    }

    public boolean isApplied(String shortClassName) {
        if (this.shortClassNamePatterns == null) {
            return true;
        }
        int i = 0;
        while (i < this.shortClassNamePatterns.length) {
            if (this.shortClassNamePatterns[i].matcher(shortClassName).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSamePackageName(String pName) {
        return pName == null ? this.packageName == null : pName.equals(this.packageName);
    }
}

