package org.seasar.jsf.render.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.util.DecodeUtil;
import org.seasar.jsf.util.RenderUtil;
import org.seasar.jsf.util.SelectItemUtil;
import org.seasar.jsf.util.ValueHolderUtil;

/**
 * @author higa
 *
 */
public class HtmlSelectOneMenuRenderer extends HtmlSelectRenderer {
	

	public void encodeEnd(FacesContext context, UIComponent component)
		throws IOException {
	
		renderSelectOneMene(context, (HtmlSelectOneMenu) component);
	}
	
	protected void renderSelectOneMene(FacesContext context, HtmlSelectOneMenu component)
			throws IOException {
		
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(JsfConstants.SELECT_ELEM, component);
        RenderUtil.renderIdIfNecessary(writer, component, context);
        writer.writeAttribute(JsfConstants.NAME_ATTR, component
                .getClientId(context), null);

        List selectItemList = SelectItemUtil.getSelectItemList(component);
        writer.writeAttribute(JsfConstants.SIZE_ATTR, "1", null);
        RenderUtil.renderAttributes(writer, component, JsfConstants.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (component.isDisabled()) {
            writer.writeAttribute(JsfConstants.DISABLED_ATTR, Boolean.TRUE, null);
        }
        String valueStr = ValueHolderUtil.getValueAsString(context, component);
        List lookupAsString = new ArrayList();
        lookupAsString.add(valueStr);
        renderSelectOptions(context, component, selectItemList, lookupAsString);
        writer.writeText("", null);
        writer.endElement(JsfConstants.SELECT_ELEM);
    }
	
	public void decode(FacesContext context, UIComponent component) {
		DecodeUtil.decode(context, component);
	}

	public Object getConvertedValue(FacesContext context,
			UIComponent component, Object submittedValue)
			throws ConverterException {
		
		return RenderUtil.getConvertedUIOutputValue(context, (UIOutput) component, submittedValue);
	}
}
