package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.TagProcessorImpl;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class SelectBooleanCheckboxSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "selectBooleanCheckbox";
	
	public SelectBooleanCheckboxSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.INPUT_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return JsfConstants.CHECKBOX_VALUE.equalsIgnoreCase(attributes
				.getValue(JsfConstants.TYPE_ATTR));
	}

	public TagProcessor createProcessor() {
		return new TagProcessorImpl(getInject());
	}
	
	public String getInject() {
		return getS2JsfInject(TAG_NAME);
	}
}