/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.seasar.jsf.component.UIElement;
import org.seasar.jsf.util.BindingUtil;
import org.seasar.jsf.util.RenderUtil;

public class HtmlElementRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (!(component instanceof UIElement)) {
            throw new IllegalArgumentException("not UIElementNode");
        }
        UIElement elem = (UIElement)component;
        String tagName = elem.getTagName();
        writer.startElement(tagName, component);
        this.renderAttributes(writer, elem);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        UIElement elem = (UIElement)component;
        writer.endElement(elem.getTagName());
        String afterContents = elem.getAfterContents();
        if (afterContents != null) {
            writer.write(afterContents);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        RenderUtil.encodeChildren(context, component);
    }

    protected void renderAttributes(ResponseWriter writer, UIElement component) throws IOException {
        if (component.isIdSet()) {
            String id = component.getId();
            RenderUtil.renderAttribute(writer, "id", id, "id");
        }
        Map attrs = component.getAttributes();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (attrName.indexOf(46) > 0) continue;
            Object value = component.getAttributes().get(attrName);
            RenderUtil.renderAttribute(writer, attrName, value, attrName);
        }
        String[] bindingPropertyNames = component.getBindingPropertyNames();
        int i2 = 0;
        while (i2 < bindingPropertyNames.length) {
            String name = bindingPropertyNames[i2];
            Object value = BindingUtil.getBindingValue((UIComponent)component, name);
            RenderUtil.renderAttribute(writer, name, value, name);
            ++i2;
        }
    }
}

