package org.seasar.jsf.util;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;

public class DoubleValidatorUtil {

    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.TYPE";

    private DoubleValidatorUtil() {
    }

    public static double parseDoubleValue(FacesContext context,
            UIComponent component, Object value) throws ValidatorException {

        if (value instanceof Number) {
            return ((Number) value).doubleValue();
        } else {
            try {
                return Double.parseDouble(value.toString());
            } catch (NumberFormatException e) {
                Object[] args = { UIComponentUtil.getLabel(component) };
                throw new ValidatorException(MessageUtil.getErrorMessage(
                        TYPE_MESSAGE_ID, args));
            }
        }
    }
}