package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputSecret;

import org.seasar.jsf.JsfConstants;

public class HtmlInputSecretTag extends HtmlInputTextTag {

    private String redisplay;

    public String getComponentType() {
        return HtmlInputSecret.COMPONENT_TYPE;
    }

    public String getRendererType() {
        return "javax.faces.Secret";
    }

    public void release() {
        super.release();
        redisplay = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        setComponentProperty(component, JsfConstants.REDISPLAY_ATTR, redisplay);
    }

    public void setRedisplay(String redisplay) {
        this.redisplay = redisplay;
    }
}
