package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;

import org.seasar.jsf.JsfConstants;

public class HtmlInputTextTag extends HtmlInputTagBase {

    private String align;

    private String maxlength;

    public String getComponentType() {
        return HtmlInputText.COMPONENT_TYPE;
    }

    public String getRendererType() {
        return "javax.faces.Text";
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    public void release() {
        super.release();
        align = null;
        maxlength = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        setComponentProperty(component, JsfConstants.ALIGN_ATTR, align);
        setComponentProperty(component, JsfConstants.MAXLENGTH_ATTR, maxlength);
    }
}