/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.Rules;
import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.CodeAdapter;
import com.tonicsystems.jarjar.asm.CodeVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.cglib.AbstractClassTransformer;

class PackageTransformer
extends AbstractClassTransformer {
    private Rules rules;
    private String className;

    public PackageTransformer(Rules rules) {
        this.rules = rules;
    }

    private String[] fixNames(String[] names) {
        if (names == null) {
            return null;
        }
        String[] fixed = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            fixed[i] = this.rules.fixName(names[i]);
        }
        return fixed;
    }

    private Object fixValue(Object value) {
        if (value instanceof String) {
            return this.rules.fixString(this.className, (String)value);
        }
        return value;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.className = name.replace('/', '.');
        this.cv.visit(version, access, this.rules.fixName(name), this.rules.fixName(superName), this.fixNames(interfaces), sourceFile);
    }

    public void visitAttribute(Attribute attr) {
        this.cv.visitAttribute(this.rules.fixAttribute(attr));
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.cv.visitField(access, name, this.rules.fixDesc(desc), this.fixValue(value), this.rules.fixAttribute(attrs));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.cv.visitInnerClass(this.rules.fixName(name), this.rules.fixName(outerName), innerName, access);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        CodeVisitor inner = this.cv.visitMethod(access, name, this.rules.fixMethodDesc(desc), this.fixNames(exceptions), this.rules.fixAttribute(attrs));
        return new CodeAdapter(inner){

            public void visitTypeInsn(int opcode, String desc) {
                this.cv.visitTypeInsn(opcode, desc.charAt(0) == '[' ? PackageTransformer.this.rules.fixDesc(desc) : PackageTransformer.this.rules.fixName(desc));
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                this.cv.visitFieldInsn(opcode, PackageTransformer.this.rules.fixName(owner), name, PackageTransformer.this.rules.fixDesc(desc));
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                this.cv.visitMethodInsn(opcode, PackageTransformer.this.rules.fixName(owner), name, PackageTransformer.this.rules.fixMethodDesc(desc));
            }

            public void visitLdcInsn(Object cst) {
                this.cv.visitLdcInsn(PackageTransformer.this.fixValue(cst));
            }

            public void visitMultiANewArrayInsn(String desc, int dims) {
                this.cv.visitMultiANewArrayInsn(PackageTransformer.this.rules.fixDesc(desc), dims);
            }

            public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                this.cv.visitTryCatchBlock(start, end, handler, PackageTransformer.this.rules.fixName(type));
            }

            public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
                this.cv.visitLocalVariable(name, PackageTransformer.this.rules.fixDesc(desc), start, end, index);
            }

            public void visitAttribute(Attribute attr) {
                this.cv.visitAttribute(PackageTransformer.this.rules.fixAttribute(attr));
            }
        };
    }
}

