/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.auto;

import java.io.File;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.auto.AutoRegister;
import org.seasar.framework.container.auto.ClassPattern;
import org.seasar.framework.container.util.Backport175Util;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class FileSystemComponentAutoRegister
extends AutoRegister {
    private static final String CLASS_SUFFIX = ".class";
    private String fileNameOfRoot = "app.dicon";

    public void setFileNameOfRoot(String fileNameOfRoot) {
        this.fileNameOfRoot = fileNameOfRoot;
    }

    public void registAll() {
        int i = 0;
        while (i < this.getClassPatternSize()) {
            ClassPattern cp = this.getClassPattern(i);
            this.regist(cp);
            ++i;
        }
    }

    protected void regist(ClassPattern classPattern) {
        String packageName = classPattern.getPackageName();
        File packageDir = this.getPackageDir(packageName);
        String[] fileNames = packageDir.list();
        int i = 0;
        while (i < fileNames.length) {
            String className;
            ComponentDef cd;
            String shortClassName;
            String fileName = fileNames[i];
            if (fileName.endsWith(CLASS_SUFFIX) && classPattern.isApplied(shortClassName = fileName.substring(0, fileName.length() - CLASS_SUFFIX.length())) && !this.hasComponentDef((cd = Backport175Util.createComponentDef(className = classPattern.convertToClassName(shortClassName))).getComponentName())) {
                Backport175Util.appendDI(cd);
                this.getContainer().register(cd);
            }
            ++i;
        }
    }

    protected File getPackageDir(String packageName) {
        File packageDir = this.getRootDir();
        if (packageName != null) {
            String[] names = StringUtil.split(packageName, ".");
            int i = 0;
            while (i < names.length) {
                packageDir = new File(packageDir, names[i]);
                ++i;
            }
        }
        return packageDir;
    }

    protected File getRootDir() {
        return ResourceUtil.getResourceAsFile(this.fileNameOfRoot).getParentFile();
    }
}

