/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.asm;

import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.ClassVisitor;
import com.tonicsystems.jarjar.asm.ClassWriter;
import com.tonicsystems.jarjar.asm.CodeVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.asm.Type;
import java.io.IOException;
import java.io.InputStream;

public class ClassReader {
    public final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    private int header;

    public ClassReader(byte[] b) {
        this(b, 0, b.length);
    }

    public ClassReader(byte[] b, int off, int len) {
        this.b = b;
        this.items = new int[this.readUnsignedShort(off + 8)];
        this.strings = new String[this.items.length];
        int max = 0;
        int index = off + 10;
        for (int i = 1; i < this.items.length; ++i) {
            int size;
            this.items[i] = index + 1;
            byte tag = b[index];
            switch (tag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index + 1);
                    max = size > max ? size : max;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index += size;
        }
        this.maxStringLength = max;
        this.header = index;
    }

    public ClassReader(InputStream is) throws IOException {
        this(ClassReader.readClass(is));
    }

    public ClassReader(String name) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    public void accept(ClassVisitor classVisitor, boolean skipDebug) {
        this.accept(classVisitor, new Attribute[0], skipDebug);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attrs, boolean skipDebug) {
        String attrName;
        Attribute attr;
        int j;
        int i;
        byte[] b = this.b;
        char[] c = new char[this.maxStringLength];
        int u = this.header;
        int version = this.readInt(4);
        int access = this.readUnsignedShort(u);
        String className = this.readClass(u + 2, c);
        int v = this.items[this.readUnsignedShort(u + 4)];
        String superClassName = v == 0 ? null : this.readUTF8(v, c);
        String[] implementedItfs = new String[this.readUnsignedShort(u + 6)];
        String sourceFile = null;
        Attribute clattrs = null;
        int w = 0;
        u += 8;
        for (i = 0; i < implementedItfs.length; ++i) {
            implementedItfs[i] = this.readClass(u, c);
            u += 2;
        }
        v = u;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            String attrName2 = this.readUTF8(v, c);
            if (attrName2.equals("SourceFile")) {
                sourceFile = this.readUTF8(v + 6, c);
            } else if (attrName2.equals("Deprecated")) {
                access |= 0x20000;
            } else if (attrName2.equals("Synthetic")) {
                access |= 0x1000;
            } else if (attrName2.equals("InnerClasses")) {
                w = v + 6;
            } else {
                attr = this.readAttribute(attrs, attrName2, v + 6, this.readInt(v + 2), c, -1, null);
                if (attr != null) {
                    attr.next = clattrs;
                    clattrs = attr;
                }
            }
            v += 6 + this.readInt(v + 2);
            --i;
        }
        classVisitor.visit(version, access, className, superClassName, implementedItfs, sourceFile);
        if (w != 0) {
            i = this.readUnsignedShort(w);
            w += 2;
            while (i > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(w) == 0 ? null : this.readClass(w, c), this.readUnsignedShort(w + 2) == 0 ? null : this.readClass(w + 2, c), this.readUnsignedShort(w + 4) == 0 ? null : this.readUTF8(w + 4, c), this.readUnsignedShort(w + 6));
                w += 8;
                --i;
            }
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            access = this.readUnsignedShort(u);
            String fieldName = this.readUTF8(u + 2, c);
            String fieldDesc = this.readUTF8(u + 4, c);
            Attribute fattrs = null;
            int fieldValueItem = 0;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                if (attrName.equals("ConstantValue")) {
                    fieldValueItem = this.readUnsignedShort(u + 6);
                } else if (attrName.equals("Synthetic")) {
                    access |= 0x1000;
                } else if (attrName.equals("Deprecated")) {
                    access |= 0x20000;
                } else {
                    attr = this.readAttribute(attrs, attrName, u + 6, this.readInt(u + 2), c, -1, null);
                    if (attr != null) {
                        attr.next = fattrs;
                        fattrs = attr;
                    }
                }
                u += 6 + this.readInt(u + 2);
                --j;
            }
            Object value = fieldValueItem == 0 ? null : this.readConst(fieldValueItem, c);
            classVisitor.visitField(access, fieldName, fieldDesc, value, fattrs);
            --i;
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            String[] exceptions;
            access = this.readUnsignedShort(u);
            String methName = this.readUTF8(u + 2, c);
            String methDesc = this.readUTF8(u + 4, c);
            Attribute mattrs = null;
            Attribute cattrs = null;
            v = 0;
            w = 0;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                int attrSize = this.readInt(u += 2);
                u += 4;
                if (attrName.equals("Code")) {
                    v = u;
                } else if (attrName.equals("Exceptions")) {
                    w = u;
                } else if (attrName.equals("Synthetic")) {
                    access |= 0x1000;
                } else if (attrName.equals("Deprecated")) {
                    access |= 0x20000;
                } else {
                    attr = this.readAttribute(attrs, attrName, u, attrSize, c, -1, null);
                    if (attr != null) {
                        attr.next = mattrs;
                        mattrs = attr;
                    }
                }
                u += attrSize;
                --j;
            }
            if (w == 0) {
                exceptions = null;
            } else {
                exceptions = new String[this.readUnsignedShort(w)];
                w += 2;
                for (j = 0; j < exceptions.length; ++j) {
                    exceptions[j] = this.readClass(w, c);
                    w += 2;
                }
            }
            CodeVisitor cv = classVisitor.visitMethod(access, methName, methDesc, exceptions, mattrs);
            if (cv != null && v != 0) {
                int k;
                int label;
                int maxStack = this.readUnsignedShort(v);
                int maxLocals = this.readUnsignedShort(v + 2);
                int codeLength = this.readInt(v + 4);
                int codeStart = v += 8;
                int codeEnd = v + codeLength;
                Label[] labels = new Label[codeLength + 1];
                block40: while (v < codeEnd) {
                    int opcode = b[v] & 0xFF;
                    switch (ClassWriter.TYPE[opcode]) {
                        case 0: 
                        case 4: {
                            ++v;
                            continue block40;
                        }
                        case 8: {
                            label = v - codeStart + this.readShort(v + 1);
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            v += 3;
                            continue block40;
                        }
                        case 9: {
                            label = v - codeStart + this.readInt(v + 1);
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            v += 5;
                            continue block40;
                        }
                        case 16: {
                            opcode = b[v + 1] & 0xFF;
                            if (opcode == 132) {
                                v += 6;
                                continue block40;
                            }
                            v += 4;
                            continue block40;
                        }
                        case 13: {
                            w = v - codeStart;
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            v += 4;
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            j = this.readInt(v);
                            v += 4;
                            for (j = this.readInt(v += 4) - j + 1; j > 0; --j) {
                                label = w + this.readInt(v);
                                v += 4;
                                if (labels[label] != null) continue;
                                labels[label] = new Label();
                            }
                            continue block40;
                        }
                        case 14: {
                            w = v - codeStart;
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            v += 4;
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            j = this.readInt(v);
                            v += 4;
                            while (j > 0) {
                                label = w + this.readInt(v += 4);
                                v += 4;
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                --j;
                            }
                            continue block40;
                        }
                        case 1: 
                        case 3: 
                        case 10: {
                            v += 2;
                            continue block40;
                        }
                        case 2: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 12: {
                            v += 3;
                            continue block40;
                        }
                        case 7: {
                            v += 5;
                            continue block40;
                        }
                    }
                    v += 4;
                }
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    label = this.readUnsignedShort(v);
                    if (labels[label] == null) {
                        labels[label] = new Label();
                    }
                    if (labels[label = this.readUnsignedShort(v + 2)] == null) {
                        labels[label] = new Label();
                    }
                    if (labels[label = this.readUnsignedShort(v + 4)] == null) {
                        labels[label] = new Label();
                    }
                    v += 8;
                    --j;
                }
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    String attrName3 = this.readUTF8(v, c);
                    if (attrName3.equals("LocalVariableTable")) {
                        if (!skipDebug) {
                            w = v + 8;
                            for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                label = this.readUnsignedShort(w);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                if (labels[label += this.readUnsignedShort(w + 2)] == null) {
                                    labels[label] = new Label();
                                }
                                w += 10;
                            }
                        }
                    } else if (attrName3.equals("LineNumberTable")) {
                        if (!skipDebug) {
                            w = v + 8;
                            for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                label = this.readUnsignedShort(w);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                w += 4;
                            }
                        }
                    } else {
                        for (k = 0; k < attrs.length; ++k) {
                            if (!attrs[k].type.equals(attrName3) || (attr = attrs[k].read(this, v + 6, this.readInt(v + 2), c, codeStart - 8, labels)) == null) continue;
                            attr.next = cattrs;
                            cattrs = attr;
                        }
                    }
                    v += 6 + this.readInt(v + 2);
                    --j;
                }
                v = codeStart;
                block48: while (v < codeEnd) {
                    w = v - codeStart;
                    Label l = labels[w];
                    if (l != null) {
                        cv.visitLabel(l);
                    }
                    int opcode = b[v] & 0xFF;
                    switch (ClassWriter.TYPE[opcode]) {
                        case 0: {
                            cv.visitInsn(opcode);
                            ++v;
                            continue block48;
                        }
                        case 4: {
                            if (opcode > 54) {
                                cv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                            } else {
                                cv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                            }
                            ++v;
                            continue block48;
                        }
                        case 8: {
                            cv.visitJumpInsn(opcode, labels[w + this.readShort(v + 1)]);
                            v += 3;
                            continue block48;
                        }
                        case 9: {
                            cv.visitJumpInsn(opcode, labels[w + this.readInt(v + 1)]);
                            v += 5;
                            continue block48;
                        }
                        case 16: {
                            opcode = b[v + 1] & 0xFF;
                            if (opcode == 132) {
                                cv.visitIincInsn(this.readUnsignedShort(v + 2), this.readShort(v + 4));
                                v += 6;
                                continue block48;
                            }
                            cv.visitVarInsn(opcode, this.readUnsignedShort(v + 2));
                            v += 4;
                            continue block48;
                        }
                        case 13: {
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            int min = this.readInt(v += 4);
                            int max = this.readInt(v += 4);
                            v += 4;
                            Label[] table = new Label[max - min + 1];
                            for (j = 0; j < table.length; ++j) {
                                table[j] = labels[w + this.readInt(v)];
                                v += 4;
                            }
                            cv.visitTableSwitchInsn(min, max, labels[label], table);
                            continue block48;
                        }
                        case 14: {
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            j = this.readInt(v += 4);
                            v += 4;
                            int[] keys = new int[j];
                            Label[] values = new Label[j];
                            for (j = 0; j < keys.length; ++j) {
                                keys[j] = this.readInt(v);
                                values[j] = labels[w + this.readInt(v += 4)];
                                v += 4;
                            }
                            cv.visitLookupSwitchInsn(labels[label], keys, values);
                            continue block48;
                        }
                        case 3: {
                            cv.visitVarInsn(opcode, b[v + 1] & 0xFF);
                            v += 2;
                            continue block48;
                        }
                        case 1: {
                            cv.visitIntInsn(opcode, b[v + 1]);
                            v += 2;
                            continue block48;
                        }
                        case 2: {
                            cv.visitIntInsn(opcode, this.readShort(v + 1));
                            v += 3;
                            continue block48;
                        }
                        case 10: {
                            cv.visitLdcInsn(this.readConst(b[v + 1] & 0xFF, c));
                            v += 2;
                            continue block48;
                        }
                        case 11: {
                            cv.visitLdcInsn(this.readConst(this.readUnsignedShort(v + 1), c));
                            v += 3;
                            continue block48;
                        }
                        case 6: 
                        case 7: {
                            int cpIndex = this.items[this.readUnsignedShort(v + 1)];
                            String iowner = this.readClass(cpIndex, c);
                            cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                            String iname = this.readUTF8(cpIndex, c);
                            String idesc = this.readUTF8(cpIndex + 2, c);
                            if (opcode < 182) {
                                cv.visitFieldInsn(opcode, iowner, iname, idesc);
                            } else {
                                cv.visitMethodInsn(opcode, iowner, iname, idesc);
                            }
                            if (opcode == 185) {
                                v += 5;
                                continue block48;
                            }
                            v += 3;
                            continue block48;
                        }
                        case 5: {
                            cv.visitTypeInsn(opcode, this.readClass(v + 1, c));
                            v += 3;
                            continue block48;
                        }
                        case 12: {
                            cv.visitIincInsn(b[v + 1] & 0xFF, b[v + 2]);
                            v += 3;
                            continue block48;
                        }
                    }
                    cv.visitMultiANewArrayInsn(this.readClass(v + 1, c), b[v + 3] & 0xFF);
                    v += 4;
                }
                Label l = labels[codeEnd - codeStart];
                if (l != null) {
                    cv.visitLabel(l);
                }
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    Label start = labels[this.readUnsignedShort(v)];
                    Label end = labels[this.readUnsignedShort(v + 2)];
                    Label handler = labels[this.readUnsignedShort(v + 4)];
                    int type = this.readUnsignedShort(v + 6);
                    if (type == 0) {
                        cv.visitTryCatchBlock(start, end, handler, null);
                    } else {
                        cv.visitTryCatchBlock(start, end, handler, this.readUTF8(this.items[type], c));
                    }
                    v += 8;
                    --j;
                }
                j = this.readUnsignedShort(v);
                v += 2;
                if (!skipDebug) {
                    while (j > 0) {
                        String attrName4 = this.readUTF8(v, c);
                        if (attrName4.equals("LocalVariableTable")) {
                            w = v + 8;
                            for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                label = this.readUnsignedShort(w);
                                Label start = labels[label];
                                Label end = labels[label += this.readUnsignedShort(w + 2)];
                                cv.visitLocalVariable(this.readUTF8(w + 4, c), this.readUTF8(w + 6, c), start, end, this.readUnsignedShort(w + 8));
                                w += 10;
                            }
                        } else if (attrName4.equals("LineNumberTable")) {
                            w = v + 8;
                            for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                cv.visitLineNumber(this.readUnsignedShort(w + 2), labels[this.readUnsignedShort(w)]);
                                w += 4;
                            }
                        }
                        v += 6 + this.readInt(v + 2);
                        --j;
                    }
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    cv.visitAttribute(cattrs);
                    cattrs = attr;
                }
                cv.visitMaxs(maxStack, maxLocals);
            }
            --i;
        }
        Attribute last = null;
        attr = clattrs;
        while (attr != null) {
            Attribute next = attr.next;
            attr.next = last;
            last = attr;
            attr = next;
        }
        while (last != null) {
            attr = last.next;
            last.next = null;
            classVisitor.visitAttribute(last);
            last = attr;
        }
        classVisitor.visitEnd();
    }

    public int getItem(int item) {
        return this.items[item];
    }

    public int readByte(int index) {
        return this.b[index] & 0xFF;
    }

    public int readUnsignedShort(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    public short readShort(int index) {
        byte[] b = this.b;
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public int readInt(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    public long readLong(int index) {
        long l1 = this.readInt(index);
        long l0 = (long)this.readInt(index + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index, char[] buf) {
        int item = this.readUnsignedShort(index);
        String s = this.strings[item];
        if (s != null) {
            return s;
        }
        index = this.items[item];
        int utfLen = this.readUnsignedShort(index);
        int endIndex = (index += 2) + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        block4: while (index < endIndex) {
            byte d;
            int c = b[index++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[strLen++] = (char)c;
                    continue block4;
                }
                case 12: 
                case 13: {
                    d = b[index++];
                    buf[strLen++] = (char)((c & 0x1F) << 6 | d & 0x3F);
                    continue block4;
                }
            }
            d = b[index++];
            byte e = b[index++];
            buf[strLen++] = (char)((c & 0xF) << 12 | (d & 0x3F) << 6 | e & 0x3F);
        }
        this.strings[item] = s = new String(buf, 0, strLen);
        return s;
    }

    public String readClass(int index, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index)], buf);
    }

    public Object readConst(int item, char[] buf) {
        int index = this.items[item];
        switch (this.b[index - 1]) {
            case 3: {
                return new Integer(this.readInt(index));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(index)));
            }
            case 5: {
                return new Long(this.readLong(index));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(index)));
            }
            case 7: {
                String s = this.readUTF8(index, buf);
                return Type.getType(s.charAt(0) == '[' ? s : "L" + s + ";");
            }
        }
        return this.readUTF8(index, buf);
    }

    protected Attribute readAttribute(Attribute[] attrs, String type, int off, int len, char[] buf, int codeOff, Label[] labels) {
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].type.equals(type)) continue;
            return attrs[i].read(this, off, len, buf, codeOff, labels);
        }
        return new Attribute(type);
    }
}

