/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.PackageTransformer;
import com.tonicsystems.jarjar.Rule;
import com.tonicsystems.jarjar.RulesImpl;
import com.tonicsystems.jarjar.Wildcard;
import com.tonicsystems.jarjar.Zap;
import com.tonicsystems.jarjar.asm.ClassReader;
import com.tonicsystems.jarjar.asm.attrs.Attributes;
import com.tonicsystems.jarjar.cglib.ClassReaderGenerator;
import com.tonicsystems.jarjar.cglib.DebuggingClassWriter;
import com.tonicsystems.jarjar.cglib.TransformingClassGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.zip.ZipOutputStream;

public class JarJarTask
extends Jar {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private ArrayList ruleList = new ArrayList();
    private ArrayList zapList = new ArrayList();
    private RulesImpl rules;
    private PackageTransformer t;
    private boolean verbose;
    private Map classNameToClassName = new HashMap();
    private byte[] buf = new byte[8192];

    private static String pathFromName(String className) {
        return className.replace('.', '/') + ".class";
    }

    private static String nameFromPath(String path) {
        String name = path.replace('/', '.');
        return name.substring(0, name.length() - 6);
    }

    public void addConfiguredRule(Rule rule) {
        if (rule.getPattern() == null || rule.getResult() == null) {
            throw new IllegalArgumentException("The <rule> element requires both \"pattern\" and \"result\" attributes.");
        }
        this.ruleList.add(rule);
    }

    public void addConfiguredZap(Zap zap) {
        if (zap.getPattern() == null) {
            throw new IllegalArgumentException("The <zap> element requires a \"pattern\" attribute.");
        }
        this.zapList.add(new Wildcard(zap.getPattern(), ""));
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void execute() throws BuildException {
        this.setFilesonly(true);
        this.rules = new RulesImpl(this.ruleList, this.verbose);
        this.t = new PackageTransformer(this.rules);
        super.execute();
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode) throws IOException {
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (fromArchive != null && vPath.equalsIgnoreCase(MANIFEST_PATH)) {
            if (this.verbose) {
                System.err.println("Ignored " + vPath);
            }
            return;
        }
        if (vPath.endsWith(".class")) {
            try {
                String oldClassName = JarJarTask.nameFromPath(vPath);
                if (this.zap("L" + vPath.substring(0, vPath.length() - 6) + ";")) {
                    if (this.verbose) {
                        System.err.println("Zapping " + oldClassName);
                    }
                    return;
                }
                DebuggingClassWriter w = new DebuggingClassWriter(false);
                ClassReaderGenerator gen = new ClassReaderGenerator(new ClassReader(is), Attributes.getDefaultAttributes(), false);
                new TransformingClassGenerator(gen, this.t).generateClass(w);
                String newClassName = w.getClassName();
                if (this.classNameToClassName.containsKey(oldClassName)) {
                    throw new BuildException("Error renaming " + oldClassName + ": already renamed " + this.classNameToClassName.get(oldClassName) + " to " + newClassName);
                }
                this.classNameToClassName.put(oldClassName, newClassName);
                if (this.verbose && !oldClassName.equals(newClassName)) {
                    System.err.println("Renamed " + oldClassName + " -> " + newClassName);
                }
                vPath = JarJarTask.pathFromName(newClassName);
                is = new ByteArrayInputStream(w.toByteArray());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            String oldPath = vPath;
            vPath = this.rules.fixPath(vPath);
            if (this.verbose) {
                if (vPath.equals(oldPath)) {
                    System.err.println("Skipped " + vPath);
                } else {
                    System.err.println("Renamed " + oldPath + " -> " + vPath);
                }
            }
        }
        super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
    }

    private static byte[] toByteArray(InputStream is, byte[] buf) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarJarTask.pipe(is, baos, buf);
        return baos.toByteArray();
    }

    private static void pipe(InputStream is, OutputStream out, byte[] buf) throws IOException {
        int amt;
        while ((amt = is.read(buf)) >= 0) {
            out.write(buf, 0, amt);
        }
    }

    private boolean zap(String desc) {
        Iterator it = this.zapList.iterator();
        while (it.hasNext()) {
            if (!((Wildcard)it.next()).matches(desc, 0)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        super.reset();
        this.cleanHelper();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.cleanHelper();
    }

    private void cleanHelper() {
        this.verbose = false;
        this.ruleList.clear();
        this.zapList.clear();
        this.classNameToClassName.clear();
    }
}

