/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepFindException;
import com.tonicsystems.jarjar.WrappedIOException;
import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.CodeAdapter;
import com.tonicsystems.jarjar.asm.CodeVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.asm.Type;
import com.tonicsystems.jarjar.cglib.NullClassVisitor;
import com.tonicsystems.jarjar.cglib.Signature;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;

class DepFindVisitor
extends NullClassVisitor {
    private Map classes;
    private String source;
    private String curName;
    private CodeVisitor code = new DepFindCodeVisitor();

    public DepFindVisitor(Map classes, Object source) throws IOException {
        this.classes = classes;
        this.source = this.getSourceName(source);
    }

    public void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.curName = name;
    }

    private void checkDesc(String desc) {
        int index = desc.indexOf(76);
        if (index >= 0) {
            this.checkName(desc.substring(index + 1, desc.length() - 1));
        }
    }

    private void checkMethodDesc(String methodDesc) {
        Signature sig = new Signature("foo", methodDesc);
        Type[] args = sig.getArgumentTypes();
        for (int i = 0; i < args.length; ++i) {
            this.checkDesc(args[i].getDescriptor());
        }
    }

    private String getSourceName(Object source) throws IOException {
        if (source instanceof ZipFile) {
            return ((ZipFile)source).getName();
        }
        return ((File)source).getCanonicalPath();
    }

    private void checkName(String name) {
        try {
            if (this.classes.containsKey(name) && !this.source.equals(this.getSourceName(this.classes.get(name)))) {
                throw new DepFindException(this.curName, name);
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        this.checkMethodDesc(desc);
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                this.checkName(exceptions[i]);
            }
        }
        return this.code;
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.checkDesc(desc);
    }

    private class DepFindCodeVisitor
    extends CodeAdapter {
        public DepFindCodeVisitor() {
            super(NullClassVisitor.INSTANCE.visitMethod(0, null, null, null, null));
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (desc.charAt(0) == '[') {
                DepFindVisitor.this.checkDesc(desc);
            } else {
                DepFindVisitor.this.checkName(desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DepFindVisitor.this.checkName(owner);
            DepFindVisitor.this.checkDesc(desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            DepFindVisitor.this.checkName(owner);
            DepFindVisitor.this.checkMethodDesc(desc);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            DepFindVisitor.this.checkDesc(desc);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            DepFindVisitor.this.checkName(type);
        }

        public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
            DepFindVisitor.this.checkDesc(desc);
        }
    }
}

