package org.seasar.struts.action;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;

/**
 * @author Satoshi Kimura
 */
public interface ActionFactory {
    /**
     * S2ReiActionNX̃CX^X擾܂B <br>
     * S2ReiɎ擾Ώۂ̃NXo^ĂȂꍇACX^X擾̑OɁA S2ReiActionNX̓o^s܂B
     * 
     * @param className 擾Ώۂ̃NX
     * @param servlet ActionɃZbgActionServletBnull̏ꍇ́Anull̓Zbg܂B
     * @return S2Rei擾ActionNX̃CX^X
     */
    Action getActionWithClassName(String className, ActionServlet servlet);

    /**
     * S2ReiActionNX̃CX^X擾܂B <br>
     * 
     * @param componentName 擾Ώۂ̃R|[lg
     * @param servlet ActionɃZbgActionServletBnull̏ꍇ́Anull̓Zbg܂B
     * @return S2Rei擾ActionNX̃CX^X
     * @throws ComponentNotFoundRuntimeException R|[lgȂꍇ
     */
    Action getActionWithComponentName(String componentName, ActionServlet servlet)
            throws ComponentNotFoundRuntimeException;

    /**
     * ActionMappingQƂāAR|[lgCX^X𐶐̂ANXCX^X𐶐̂𔻒fāA ActioñCX^X𐶐B
     * 
     * @param request ĂHTTPNGXg
     * @param response HTTPX|X
     * @param mapping ActioñCX^X𐶐邽߂Ɏgp
     * @param log O
     * @param internal bZ[W\[X
     * @param servlet ActionɊ֘AÂĂServlet̃CX^X
     * @return S2Rei擾ActionNX̃CX^X
     * @throws IOException CX^XɎsꍇɁAX|X𑀍쎞ɔO
     */
    Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping,
            Log log, MessageResources internal, ActionServlet servlet) throws IOException;

    /**
     * Get action instance from S2Container.
     * 
     * @param mapping
     * @param log
     * @param internal
     * @param servlet
     * @return POJO instance or {@see Action}instance.
     * @throws IOException
     */
    Object getActionInstance(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping, Log log,
            MessageResources internal, ActionServlet servlet) throws IOException;
}