/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.httpunit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.httpunit.core.StandardContext;
import org.seasar.httpunit.exception.FileNotFoundRuntimeException;
import org.seasar.httpunit.exception.LifecycleRuntimeException;
import org.seasar.httpunit.exception.ServletRuntimeException;
import org.seasar.httpunit.mock.HttpServletRequestDelegator;
import org.seasar.httpunit.mock.MockHttpServletRequest;
import org.seasar.httpunit.mock.MockHttpServletResponse;
import org.seasar.httpunit.mock.MockObjectInterceptor;
import org.seasar.httpunit.mock.MockObjectInterceptorMapping;

public class S2HttpTestCase
extends S2TestCase {
    private boolean useS2MockObject;
    private StandardContext context;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private ServletContext servletContext;
    private String path;
    private String webappsName;
    private int portStringLength = 0;
    static /* synthetic */ Class class$org$seasar$httpunit$mock$MockHttpServletRequest;
    static /* synthetic */ Class class$org$seasar$httpunit$mock$MockHttpServletResponse;
    static /* synthetic */ Class class$org$seasar$httpunit$mock$HttpServletRequestDelegator;

    protected S2HttpTestCase(String name) {
        this(name, false);
    }

    protected S2HttpTestCase(String name, boolean useS2MockObject) {
        super(name);
        this.useS2MockObject = useS2MockObject;
    }

    protected void setUpContainer() throws Throwable {
        super.setUpContainer();
        if (!this.useS2MockObject) {
            this.setServletContext(null);
            this.setRequest(null);
            this.setResponse(null);
            this.getContainer().setServletContext(null);
            this.getContainer().setRequest(null);
            this.getContainer().setResponse(null);
        }
    }

    protected void setUpAfterContainerInit() throws Throwable {
        if (!this.useS2MockObject) {
            MockHttpServletRequest req = (MockHttpServletRequest)this.getComponent(class$org$seasar$httpunit$mock$MockHttpServletRequest == null ? (class$org$seasar$httpunit$mock$MockHttpServletRequest = S2HttpTestCase.class$("org.seasar.httpunit.mock.MockHttpServletRequest")) : class$org$seasar$httpunit$mock$MockHttpServletRequest);
            MockHttpServletResponse res = (MockHttpServletResponse)this.getComponent(class$org$seasar$httpunit$mock$MockHttpServletResponse == null ? (class$org$seasar$httpunit$mock$MockHttpServletResponse = S2HttpTestCase.class$("org.seasar.httpunit.mock.MockHttpServletResponse")) : class$org$seasar$httpunit$mock$MockHttpServletResponse);
            this.setMockReq(req);
            this.setMockRes(res);
            this.getContainer().setRequest((HttpServletRequest)req);
            this.getContainer().setResponse((HttpServletResponse)res);
            try {
                HttpServletRequestDelegator delegator = (HttpServletRequestDelegator)this.getComponent(class$org$seasar$httpunit$mock$HttpServletRequestDelegator == null ? (class$org$seasar$httpunit$mock$HttpServletRequestDelegator = S2HttpTestCase.class$("org.seasar.httpunit.mock.HttpServletRequestDelegator")) : class$org$seasar$httpunit$mock$HttpServletRequestDelegator);
                delegator.setContainer(this.getContainer());
            }
            catch (ComponentNotFoundRuntimeException componentNotFoundRuntimeException) {
                // empty catch block
            }
        }
    }

    protected MockHttpServletRequest getMockReq() {
        return this.request;
    }

    private void setMockReq(MockHttpServletRequest request) {
        this.request = request;
    }

    protected HttpServletRequest getHttpServletRequest() {
        if (this.useS2MockObject) {
            return this.getRequest();
        }
        return this.getMockReq();
    }

    protected MockHttpServletResponse getMockRes() {
        return this.response;
    }

    private void setMockRes(MockHttpServletResponse response) {
        this.response = response;
    }

    protected HttpServletResponse getHttpServletResponse() {
        if (this.useS2MockObject) {
            return this.getResponse();
        }
        return this.getMockRes();
    }

    protected ServletContext getContext() {
        return this.servletContext;
    }

    private void setContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected ServletContext getServletCxt() {
        if (this.useS2MockObject) {
            return this.getServletContext();
        }
        return this.getContext();
    }

    protected void setDocBase(String docBase) {
        String docBasePath = this.convertDocBasePath(docBase);
        this.setContext(this.createServletContext(docBasePath));
        this.getContainer().setServletContext(this.servletContext);
        SingletonS2ContainerFactory.setServletContext((ServletContext)this.servletContext);
        SingletonS2ContainerFactory.init();
        this.loadOnStartup();
    }

    protected HttpServlet getHttpServlet(String servletName) {
        return this.context.getHttpServlet(servletName);
    }

    protected HttpServlet getHttpServlet(Class servletClass) {
        return this.context.getHttpServlet(servletClass);
    }

    protected String getWebappsName() {
        return this.webappsName;
    }

    protected void setWebappsName(String webappsName) {
        this.webappsName = webappsName;
        this.setReturnValue(class$org$seasar$httpunit$mock$MockHttpServletRequest == null ? (class$org$seasar$httpunit$mock$MockHttpServletRequest = S2HttpTestCase.class$("org.seasar.httpunit.mock.MockHttpServletRequest")) : class$org$seasar$httpunit$mock$MockHttpServletRequest, "getContextPath", "/" + webappsName);
    }

    protected String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
        String url = this.createRequestURL();
        MockObjectInterceptor interceptor = this.getMockComponent(class$org$seasar$httpunit$mock$MockHttpServletRequest == null ? (class$org$seasar$httpunit$mock$MockHttpServletRequest = S2HttpTestCase.class$("org.seasar.httpunit.mock.MockHttpServletRequest")) : class$org$seasar$httpunit$mock$MockHttpServletRequest);
        int pos = url.indexOf(63);
        if (pos < 0) {
            pos = Integer.MAX_VALUE;
        } else {
            String queryString = url.substring(pos + 1);
            interceptor.setReturnValue("getQueryString", queryString);
        }
        String requestURL = url.substring(0, pos);
        String requestURI = requestURL.substring(url.indexOf(this.request.getServerName()) + this.request.getServerName().length() + this.portStringLength);
        interceptor.setReturnValue("getRequestURI", requestURI);
        interceptor.setReturnValue("getRequestURL", new StringBuffer(requestURL));
        String servletPath = requestURI;
        if (this.hasWebappsName()) {
            pos = requestURI.indexOf(this.getWebappsName());
            servletPath = requestURI.substring(pos + this.getWebappsName().length());
        }
        interceptor.setReturnValue("getServletPath", servletPath);
    }

    private boolean hasWebappsName() {
        return this.getWebappsName() != null && this.getWebappsName().length() != 0;
    }

    private String createRequestURL() {
        String scheme = this.request.getScheme();
        int port = this.request.getServerPort();
        StringBuffer urlBuffer = new StringBuffer(scheme);
        urlBuffer.append("://");
        urlBuffer.append(this.request.getServerName());
        this.portStringLength = 0;
        if (!(0 >= port || "http".equals(scheme) && 80 == port || "https".equals(scheme) && 443 == port)) {
            urlBuffer.append(":" + this.request.getServerPort());
            this.portStringLength = ":".length() + Integer.toString(this.request.getServerPort()).length();
        }
        if (this.getWebappsName() != null) {
            urlBuffer.append("/");
            urlBuffer.append(this.getWebappsName());
        }
        urlBuffer.append(this.path);
        String url = urlBuffer.toString();
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.setUpForS2HttpTestCase();
        try {
            super.runBare();
        }
        finally {
            this.tearDownForS2HttpTestCase();
        }
    }

    private void setUpForS2HttpTestCase() {
    }

    private void tearDownForS2HttpTestCase() {
        try {
            if (this.context != null) {
                this.context.stop();
            }
        }
        catch (LifecycleException e) {
            throw new LifecycleRuntimeException(e);
        }
    }

    private void loadOnStartup() {
        try {
            this.context.loadOnStartup();
            this.context.getHttpServlets();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ServletException e) {
            throw new ServletRuntimeException(e);
        }
    }

    private ServletContext createServletContext(String docBase) {
        this.context = new StandardContext();
        this.context.setDocBase(docBase);
        try {
            this.context.start();
        }
        catch (LifecycleException e) {
            throw new LifecycleRuntimeException(e);
        }
        return this.context.getServletContext();
    }

    private String convertDocBasePath(String path) {
        String prefix = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/');
        if (path.length() != 0) {
            path = path + "/";
        }
        path = path + "WEB-INF";
        String resourcePath = prefix + "/" + path;
        if (ResourceUtil.getResourceNoException((String)path) != null) {
            return new File(ResourceUtil.getClassLoader().getResource(path).getFile()).getParent();
        }
        if (ResourceUtil.getResourceNoException((String)resourcePath) != null) {
            path = resourcePath;
            return new File(ResourceUtil.getClassLoader().getResource(path).getFile()).getParent();
        }
        if (!new File(path).exists()) {
            throw new FileNotFoundRuntimeException(path);
        }
        return new File(path).getParent();
    }

    protected void setRequestReturnValue(String methodName, Object value) {
        this.setReturnValue(class$org$seasar$httpunit$mock$MockHttpServletRequest == null ? (class$org$seasar$httpunit$mock$MockHttpServletRequest = S2HttpTestCase.class$("org.seasar.httpunit.mock.MockHttpServletRequest")) : class$org$seasar$httpunit$mock$MockHttpServletRequest, methodName, value);
    }

    protected void setRequestReturnValue(String methodName, Object key, Object value) {
        this.setReturnValue(class$org$seasar$httpunit$mock$MockHttpServletRequest == null ? (class$org$seasar$httpunit$mock$MockHttpServletRequest = S2HttpTestCase.class$("org.seasar.httpunit.mock.MockHttpServletRequest")) : class$org$seasar$httpunit$mock$MockHttpServletRequest, methodName, key, value);
    }

    protected void setResponseReturnValue(String methodName, Object value) {
        this.setReturnValue(class$org$seasar$httpunit$mock$MockHttpServletResponse == null ? (class$org$seasar$httpunit$mock$MockHttpServletResponse = S2HttpTestCase.class$("org.seasar.httpunit.mock.MockHttpServletResponse")) : class$org$seasar$httpunit$mock$MockHttpServletResponse, methodName, value);
    }

    protected void setResponseReturnValue(String methodName, Object key, Object value) {
        this.setReturnValue(class$org$seasar$httpunit$mock$MockHttpServletResponse == null ? (class$org$seasar$httpunit$mock$MockHttpServletResponse = S2HttpTestCase.class$("org.seasar.httpunit.mock.MockHttpServletResponse")) : class$org$seasar$httpunit$mock$MockHttpServletResponse, methodName, key, value);
    }

    private void setReturnValue(Class clazz, String methodName, Object value) {
        MockObjectInterceptor interceptor = this.getMockComponent(clazz);
        interceptor.setReturnValue(methodName, value);
    }

    private void setReturnValue(Class clazz, String methodName, Object key, Object value) {
        MockObjectInterceptor interceptor = this.getMockComponent(clazz);
        interceptor.setReturnValue(methodName, key, value);
    }

    protected void sort(String[] arrays) {
        Arrays.sort(arrays);
    }

    protected static List toSortedList(Enumeration e) {
        if (e == null) {
            return null;
        }
        ArrayList sortedList = new ArrayList();
        while (e.hasMoreElements()) {
            sortedList.add(e.nextElement());
        }
        Collections.sort(sortedList);
        return sortedList;
    }

    private MockObjectInterceptor getMockComponent(Class clazz) {
        return (MockObjectInterceptor)((Object)this.getComponent(MockObjectInterceptorMapping.getMockObjectInterceptorName(clazz)));
    }

    public void assertEquals(String message, Object[] expected, Object[] actual) {
        message = message == null ? "" : message;
        S2HttpTestCase.assertEquals((String)(message + " length"), (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            S2HttpTestCase.assertEquals((String)(message + " index is " + i), (Object)expected[i], (Object)actual[i]);
        }
    }

    public void assertEquals(Object[] expected, Object[] actual) {
        this.assertEquals(null, expected, actual);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

