/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.seasar.framework.exception.ParseRuntimeException;
import org.seasar.framework.util.StringUtil;

public final class DateConversionUtil {
    private DateConversionUtil() {
    }

    public static Date toDate(Object o) {
        return DateConversionUtil.toDate(o, null);
    }

    public static Date toDate(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return DateConversionUtil.toDate((String)o, pattern);
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Calendar) {
            return ((Calendar)o).getTime();
        }
        return DateConversionUtil.toDate(o.toString(), pattern);
    }

    public static Date toDate(String s, String pattern) {
        return DateConversionUtil.toDate(s, pattern, Locale.getDefault());
    }

    public static Date toDate(String s, String pattern, Locale locale) {
        SimpleDateFormat sdf = DateConversionUtil.getDateFormat(s, pattern, locale);
        try {
            return sdf.parse(s);
        }
        catch (ParseException ex) {
            throw new ParseRuntimeException(ex);
        }
    }

    public static SimpleDateFormat getDateFormat(String s, String pattern, Locale locale) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern);
        }
        return DateConversionUtil.getDateFormat(s, locale);
    }

    public static SimpleDateFormat getDateFormat(String s, Locale locale) {
        String pattern = DateConversionUtil.getPattern(locale);
        String shortPattern = DateConversionUtil.removeDelimiter(pattern);
        String delimitor = DateConversionUtil.findDelimiter(s);
        if (delimitor == null) {
            if (s.length() == shortPattern.length()) {
                return new SimpleDateFormat(shortPattern);
            }
            if (s.length() == shortPattern.length() + 2) {
                return new SimpleDateFormat(StringUtil.replace(shortPattern, "yy", "yyyy"));
            }
        } else {
            String[] array = StringUtil.split(s, delimitor);
            int i = 0;
            while (i < array.length) {
                if (array[i].length() == 4) {
                    pattern = StringUtil.replace(pattern, "yy", "yyyy");
                    break;
                }
                ++i;
            }
            return new SimpleDateFormat(pattern);
        }
        return new SimpleDateFormat();
    }

    public static SimpleDateFormat getDateFormat(Locale locale) {
        return new SimpleDateFormat(DateConversionUtil.getPattern(locale));
    }

    public static SimpleDateFormat getY4DateFormat(Locale locale) {
        return new SimpleDateFormat(DateConversionUtil.getY4Pattern(locale));
    }

    public static String getY4Pattern(Locale locale) {
        String pattern = DateConversionUtil.getPattern(locale);
        if (pattern.indexOf("yyyy") < 0) {
            pattern = StringUtil.replace(pattern, "yy", "yyyy");
        }
        return pattern;
    }

    public static String getPattern(Locale locale) {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        String pattern = df.toPattern();
        int index = pattern.indexOf(32);
        if (index > 0) {
            pattern = pattern.substring(0, index);
        }
        if (pattern.indexOf("MM") < 0) {
            pattern = StringUtil.replace(pattern, "M", "MM");
        }
        if (pattern.indexOf("dd") < 0) {
            pattern = StringUtil.replace(pattern, "d", "dd");
        }
        return pattern;
    }

    public static String findDelimiter(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!Character.isDigit(c)) {
                return Character.toString(c);
            }
            ++i;
        }
        return null;
    }

    public static String removeDelimiter(String pattern) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == 'y' || c == 'M' || c == 'd') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }
}

