/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.seasar.framework.util.ClassUtil;
import org.seasar.struts.util.ClassFinder;

public class ClassFinderImpl
implements ClassFinder {
    private static final Logger logger = Logger.getLogger((Class)(class$org$seasar$struts$util$ClassFinderImpl == null ? (class$org$seasar$struts$util$ClassFinderImpl = ClassFinderImpl.class$("org.seasar.struts.util.ClassFinderImpl")) : class$org$seasar$struts$util$ClassFinderImpl));
    private static final String CLASS_FILE_EXTENTION = ".class";
    private static final int CLASS_FILE_EXTENTION_LENGTH = ".class".length();
    private static final char FILE_SEPARATOR = File.separatorChar;
    private Collection classCollection = new ArrayList();
    static /* synthetic */ Class class$org$seasar$struts$util$ClassFinderImpl;

    public void find() {
        this.find(true);
    }

    public synchronized void find(boolean enableJar) {
        String cp = System.getProperty("java.class.path");
        String ps = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(cp, ps);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            this.loadAllClass(path, enableJar);
        }
    }

    public synchronized void find(String path, boolean enableJar) {
        this.loadAllClass(path, enableJar);
    }

    public synchronized void find(File file, boolean enableJar) {
        this.loadAllClass(file.getAbsolutePath(), enableJar);
    }

    private void loadAllClass(String classpath, boolean enableJar) {
        File path = new File(classpath);
        if (!path.exists()) {
            return;
        }
        if (path.isDirectory()) {
            this.loadFromDir(path, path);
        } else if (enableJar) {
            this.loadFromJar(path);
        }
    }

    private void loadFromJar(File path) {
        JarFile jarFile = ClassFinderImpl.createJarFileInstance(path);
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String entryName = ((Object)entries.nextElement()).toString();
            if (!entryName.endsWith(CLASS_FILE_EXTENTION)) continue;
            String classResourceName = entryName;
            Class clazz = ClassFinderImpl.forResourceName(classResourceName);
            this.addToCollection(clazz);
        }
    }

    private static JarFile createJarFileInstance(File path) {
        try {
            return new JarFile(path);
        }
        catch (IOException e) {
            logger.warn((Object)e.toString());
            return null;
        }
    }

    private void loadFromDir(File rootPath, File path) {
        File[] files = path.listFiles();
        int rootPathDirNameLength = rootPath.getAbsolutePath().length() + 1;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.loadFromDir(rootPath, files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(CLASS_FILE_EXTENTION)) continue;
            String classFilePath = files[i].getAbsolutePath();
            String classResourceName = classFilePath.substring(rootPathDirNameLength);
            Class clazz = ClassFinderImpl.forResourceName(classResourceName);
            this.addToCollection(clazz);
        }
    }

    private void addToCollection(Class clazz) {
        if (clazz == null) {
            return;
        }
        this.classCollection.add(clazz);
    }

    private static final Class forResourceName(String classResourceName) {
        String className = classResourceName.substring(0, classResourceName.length() - CLASS_FILE_EXTENTION_LENGTH);
        className = className.replace(FILE_SEPARATOR, '.');
        className = className.replace('/', '.');
        try {
            Class clazz = ClassUtil.forName((String)className);
            return clazz;
        }
        catch (NoClassDefFoundError e) {
            logger.warn((Object)e.toString());
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn((Object)e.toString());
            return null;
        }
    }

    public synchronized Collection getClassCollection() {
        return this.classCollection;
    }

    public synchronized void destroy() {
        this.classCollection = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

