package test.org.seasar.framework.container.util;

import junit.framework.TestCase;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.util.Backport175Util;

/**
 * @author higa
 */
public class Backport175UtilTest extends TestCase {

    public void testCreateComponentDef() throws Exception {
        ComponentDef cd = Backport175Util.createComponentDef(Foo.class);
        assertEquals("1", "foo", cd.getComponentName());
        assertEquals("2", "prototype", cd.getInstanceMode());
        assertEquals("3", "property", cd.getAutoBindingMode());
        
        ComponentDef cd2 = Backport175Util.createComponentDef(Foo2.class);
        assertEquals("4", null, cd2.getComponentName());
        assertEquals("5", "singleton", cd2.getInstanceMode());
        assertEquals("6", "auto", cd2.getAutoBindingMode());
        
        ComponentDef cd3 = Backport175Util.createComponentDef(Foo3.class);
        assertNotNull("7", cd3);
    }
    
    public void testCreatePropertyDefForInject() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(Foo.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("foo2");
        PropertyDef propDef = Backport175Util.createPropertyDef(propDesc);
        assertNotNull("1", propDef);
        assertEquals("2", "foo2", propDef.getPropertyName());
        assertEquals("3", "f2", propDef.getExpression());
        assertEquals("4", false, propDef.isNoInject());
    }
    
    public void testCreatePropertyDefForNoInject() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(Foo.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("foo3");
        PropertyDef propDef = Backport175Util.createPropertyDef(propDesc);
        assertNotNull("1", propDef);
        assertEquals("2", "foo3", propDef.getPropertyName());
        assertEquals("3", true, propDef.isNoInject());
    }
}