package test.org.seasar.framework.container.auto;

import junit.framework.TestCase;

import org.seasar.framework.container.auto.ClassPattern;

/**
 * @author higa
 */
public class ClassPatternTest extends TestCase {

    public void testAppliedForShortClassNameNull() throws Exception {
        ClassPattern cp = new ClassPattern();
        assertTrue("1", cp.isApplied("Hoge"));
    }
    
    public void testAppliedForNormalPattern() throws Exception {
        ClassPattern cp = new ClassPattern();
        cp.setShortClassName(".*Impl");
        assertTrue("1", cp.isApplied("HogeImpl"));
        assertFalse("2", cp.isApplied("Hoge"));
    }
    
    public void testAppliedForMulti() throws Exception {
        ClassPattern cp = new ClassPattern();
        cp.setShortClassName("Hoge, HogeImpl");
        assertTrue("1", cp.isApplied("HogeImpl"));
        assertTrue("2", cp.isApplied("Hoge"));
        assertFalse("3", cp.isApplied("Hoge2"));
    }
    
    public void testConvertToClassPathForPackageNull() throws Exception {
        ClassPattern cp = new ClassPattern();
        assertEquals("1", "Hoge", cp.convertToClassName("Hoge"));
    }
    
    public void testConvertToClassPathForPackageNotNull() throws Exception {
        ClassPattern cp = new ClassPattern();
        cp.setPackageName("aaa.bbb");
        assertEquals("1", "aaa.bbb.Hoge", cp.convertToClassName("Hoge"));
    }
}